/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.javax.tests.DataUtils;
import org.eclipse.jetty.websocket.javax.tests.Timeouts;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public abstract class WSEndpointTracker
extends Endpoint {
    public final Logger logger;
    public Session session;
    public EndpointConfig config;
    public CountDownLatch openLatch = new CountDownLatch(1);
    public CountDownLatch closeLatch = new CountDownLatch(1);
    public AtomicReference<CloseReason> closeDetail = new AtomicReference();
    public AtomicReference<Throwable> error = new AtomicReference();
    public BlockingQueue<String> messageQueue = new LinkedBlockingDeque<String>();
    public BlockingQueue<ByteBuffer> bufferQueue = new LinkedBlockingDeque<ByteBuffer>();

    public WSEndpointTracker() {
        this("WSEndpointTracker");
    }

    public WSEndpointTracker(String id) {
        this.logger = Log.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + id));
        this.logger.debug("init", new Object[0]);
    }

    public void assertCloseInfo(String prefix, int expectedCloseStatusCode, Matcher<? super String> reasonMatcher) throws InterruptedException {
        CloseReason close = this.closeDetail.get();
        MatcherAssert.assertThat((String)(prefix + " close info"), (Object)close, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)(prefix + " received close code"), (Object)close.getCloseCode().getCode(), (Matcher)Matchers.is((Object)expectedCloseStatusCode));
        MatcherAssert.assertThat((String)(prefix + " received close reason"), (Object)close.getReasonPhrase(), reasonMatcher);
    }

    public void assertErrorEvent(String prefix, Matcher<Throwable> throwableMatcher, Matcher<? super String> messageMatcher) {
        MatcherAssert.assertThat((String)(prefix + " error event type"), (Object)this.error.get(), throwableMatcher);
        MatcherAssert.assertThat((String)(prefix + " error event message"), (Object)this.error.get().getMessage(), messageMatcher);
    }

    public void assertNoErrorEvents(String prefix) {
        Assertions.assertTrue((this.error.get() == null ? 1 : 0) != 0, (String)(prefix + " error event should not have occurred"));
    }

    public void assertNotClosed(String prefix) {
        Assertions.assertTrue((this.closeLatch.getCount() > 0L ? 1 : 0) != 0, (String)(prefix + " close event should not have occurred"));
    }

    public void assertNotOpened(String prefix) {
        Assertions.assertTrue((this.openLatch.getCount() > 0L ? 1 : 0) != 0, (String)(prefix + " onOpen event should not have occurred"));
    }

    public void awaitCloseEvent(String prefix) throws InterruptedException {
        Assertions.assertTrue((boolean)this.closeLatch.await(Timeouts.CLOSE_EVENT_MS, TimeUnit.MILLISECONDS), (String)(prefix + " onClose event"));
    }

    public void awaitOpenEvent(String prefix) throws InterruptedException {
        Assertions.assertTrue((boolean)this.openLatch.await(Timeouts.OPEN_EVENT_MS, TimeUnit.MILLISECONDS), (String)(prefix + " onOpen event"));
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        this.config = config;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("onOpen({}, {})", new Object[]{session, config});
        }
        this.openLatch.countDown();
    }

    public void onClose(Session session, CloseReason closeReason) {
        boolean closeTracked = this.closeDetail.compareAndSet(null, closeReason);
        this.closeLatch.countDown();
        Assertions.assertTrue((boolean)closeTracked, (String)"Close should only happened once");
    }

    public void onError(Session session, Throwable cause) {
        MatcherAssert.assertThat((String)"Error must have value", (Object)cause, (Matcher)Matchers.notNullValue());
        if (!this.error.compareAndSet(null, cause)) {
            this.logger.warn("onError should only happen once - Original Cause", this.error.get());
            this.logger.warn("onError should only happen once - Extra/Excess Cause", cause);
            Assertions.fail((String)"onError should only happen once!");
        }
    }

    protected void onWsText(String message) {
        this.messageQueue.offer(message);
    }

    protected void onWsBinary(ByteBuffer buffer) {
        ByteBuffer copy = DataUtils.copyOf(buffer);
        this.bufferQueue.offer(copy);
    }
}

