/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpHeader;

public class UpgradeUtils {
    public static String generateUpgradeRequest(CharSequence requestPath, Map<String, String> headers) {
        StringBuilder upgradeRequest = new StringBuilder();
        upgradeRequest.append("GET ");
        upgradeRequest.append(requestPath == null ? "/" : requestPath);
        upgradeRequest.append(" HTTP/1.1\r\n");
        headers.entrySet().stream().forEach(e -> upgradeRequest.append((String)e.getKey()).append(": ").append((String)e.getValue()).append("\r\n"));
        upgradeRequest.append("\r\n");
        return upgradeRequest.toString();
    }

    public static String generateUpgradeRequest() {
        return UpgradeUtils.generateUpgradeRequest("/", UpgradeUtils.newDefaultUpgradeRequestHeaders());
    }

    public static String generateUpgradeRequest(CharSequence requestPath) {
        return UpgradeUtils.generateUpgradeRequest(requestPath, UpgradeUtils.newDefaultUpgradeRequestHeaders());
    }

    public static Map<String, String> newDefaultUpgradeRequestHeaders() {
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        headers.put("Host", "local");
        headers.put("Connection", "Upgrade");
        headers.put("Upgrade", "WebSocket");
        headers.put(HttpHeader.SEC_WEBSOCKET_KEY.asString(), "dGhlIHNhbXBsZSBub25jZQ==");
        headers.put(HttpHeader.ORIGIN.asString(), "ws://local/");
        headers.put(HttpHeader.SEC_WEBSOCKET_VERSION.asString(), "13");
        return headers;
    }
}

