/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.internal.Generator;

public class UnitGenerator
extends Generator {
    private static final byte[] MASK = new byte[]{17, 34, 51, 68};
    private final boolean applyMask;

    public UnitGenerator(Behavior behavior) {
        super((ByteBufferPool)new MappedByteBufferPool());
        this.applyMask = behavior == Behavior.CLIENT;
    }

    public ByteBuffer asBuffer(List<Frame> frames) {
        int bufferLength = 0;
        for (Frame f : frames) {
            bufferLength += f.getPayloadLength() + 28;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferLength);
        this.generate(buffer, frames);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        return buffer;
    }

    public ByteBuffer asBuffer(Frame ... frames) {
        return this.asBuffer(Arrays.asList(frames));
    }

    public void generate(ByteBuffer buffer, List<Frame> frames) {
        for (Frame f : frames) {
            if (this.applyMask) {
                f.setMask(MASK);
            }
            this.generateWholeFrame(f, buffer);
        }
    }

    public void generate(ByteBuffer buffer, Frame ... frames) {
        for (Frame f : frames) {
            if (this.applyMask) {
                f.setMask(MASK);
            }
            this.generateWholeFrame(f, buffer);
        }
    }

    public ByteBuffer generate(Frame frame) {
        return this.asBuffer(Collections.singletonList(frame));
    }

    public void generate(ByteBuffer buffer, Frame frame) {
        if (this.applyMask) {
            frame.setMask(MASK);
        }
        this.generateWholeFrame(frame, buffer);
    }
}

