/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.javax.tests.Fuzzer;
import org.eclipse.jetty.websocket.javax.tests.LocalServer;
import org.eclipse.jetty.websocket.javax.tests.UnitGenerator;
import org.junit.jupiter.api.Assertions;

public class NetworkFuzzer
extends Fuzzer.Adapter
implements Fuzzer,
AutoCloseable {
    private final LocalServer server;
    private final WebSocketCoreClient client;
    private final RawUpgradeRequest upgradeRequest;
    private final UnitGenerator generator;
    private final FrameCapture frameCapture;
    private SharedBlockingCallback sharedBlockingCallback = new SharedBlockingCallback();

    public NetworkFuzzer(LocalServer server) throws Exception {
        this(server, server.getWsUri());
    }

    public NetworkFuzzer(LocalServer server, URI wsURI) throws Exception {
        this(server, wsURI, null);
    }

    public NetworkFuzzer(LocalServer server, URI wsURI, Map<String, String> requestHeaders) throws Exception {
        this.server = server;
        this.client = new WebSocketCoreClient();
        this.upgradeRequest = new RawUpgradeRequest(this.client, wsURI);
        if (requestHeaders != null) {
            HttpFields fields = this.upgradeRequest.getHeaders();
            requestHeaders.forEach((name, value) -> {
                fields.remove(name);
                fields.put(name, value);
            });
        }
        this.client.start();
        this.generator = new UnitGenerator(Behavior.CLIENT);
        CompletableFuture futureHandler = this.client.connect((ClientUpgradeRequest)this.upgradeRequest);
        CompletionStage futureCapture = futureHandler.thenCombine(this.upgradeRequest.getFuture(), (session, capture) -> capture);
        this.frameCapture = (FrameCapture)((CompletableFuture)futureCapture).get(10L, TimeUnit.SECONDS);
    }

    @Override
    public ByteBuffer asNetworkBuffer(List<Frame> frames) {
        int bufferLength = frames.stream().mapToInt(f -> f.getPayloadLength() + 28).sum();
        ByteBuffer buffer = ByteBuffer.allocate(bufferLength);
        for (Frame f2 : frames) {
            this.generator.generate(buffer, f2);
        }
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        return buffer;
    }

    @Override
    public void close() throws Exception {
        this.client.stop();
    }

    @Override
    public void eof() {
    }

    @Override
    public void expect(List<Frame> expected) throws InterruptedException {
        this.assertExpected(this.frameCapture.receivedFrames, expected);
    }

    @Override
    public BlockingQueue<Frame> getOutputFrames() {
        return this.frameCapture.receivedFrames;
    }

    @Override
    public void send(ByteBuffer buffer) throws IOException {
        this.frameCapture.writeRaw(buffer);
    }

    @Override
    public void send(ByteBuffer buffer, int length) throws IOException {
        int limit = Math.min(length, buffer.remaining());
        ByteBuffer sliced = buffer.slice();
        sliced.limit(limit);
        this.frameCapture.writeRaw(sliced);
        buffer.position(buffer.position() + limit);
    }

    @Override
    public void sendBulk(List<Frame> frames) throws IOException {
        this.frameCapture.writeRaw(this.asNetworkBuffer(frames));
    }

    @Override
    public void sendFrames(List<Frame> frames) throws IOException {
        for (Frame f : frames) {
            SharedBlockingCallback.Blocker blocker = this.sharedBlockingCallback.acquire();
            try {
                this.frameCapture.coreSession.sendFrame(f, (Callback)blocker, false);
            }
            finally {
                if (blocker == null) continue;
                blocker.close();
            }
        }
    }

    @Override
    public void sendFrames(Frame ... frames) throws IOException {
        for (Frame f : frames) {
            try (SharedBlockingCallback.Blocker blocker = this.sharedBlockingCallback.acquire();){
                this.frameCapture.coreSession.sendFrame(f, (Callback)blocker, false);
            }
        }
    }

    @Override
    public void sendSegmented(List<Frame> frames, int segmentSize) throws IOException {
        ByteBuffer buffer = this.asNetworkBuffer(frames);
        while (buffer.remaining() > 0) {
            this.send(buffer, segmentSize);
        }
    }

    public static class FrameCapture
    implements FrameHandler {
        private final BlockingQueue<Frame> receivedFrames = new LinkedBlockingQueue<Frame>();
        private EndPoint endPoint;
        private CountDownLatch openLatch = new CountDownLatch(1);
        private final SharedBlockingCallback blockingCallback = new SharedBlockingCallback();
        private FrameHandler.CoreSession coreSession;

        public void setEndPoint(EndPoint endpoint) {
            this.endPoint = endpoint;
        }

        public void onOpen(FrameHandler.CoreSession coreSession, Callback callback) {
            this.coreSession = coreSession;
            this.openLatch.countDown();
            callback.succeeded();
        }

        public void onFrame(Frame frame, Callback callback) {
            this.receivedFrames.offer(Frame.copy((Frame)frame));
            callback.succeeded();
        }

        public void onError(Throwable cause, Callback callback) {
            callback.succeeded();
        }

        public void onClosed(CloseStatus closeStatus, Callback callback) {
            callback.succeeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRaw(ByteBuffer buffer) throws IOException {
            try {
                Assertions.assertTrue((boolean)this.openLatch.await(1L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            FrameCapture frameCapture = this;
            synchronized (frameCapture) {
                try (SharedBlockingCallback.Blocker blocker = this.blockingCallback.acquire();){
                    this.endPoint.write((Callback)blocker, new ByteBuffer[]{buffer});
                }
            }
        }
    }

    public static class RawUpgradeRequest
    extends ClientUpgradeRequest {
        private final FrameCapture frameCapture = new FrameCapture();
        private final CompletableFuture<FrameCapture> futureCapture = new CompletableFuture();

        public RawUpgradeRequest(WebSocketCoreClient webSocketClient, URI requestURI) {
            super(webSocketClient, requestURI);
        }

        public CompletableFuture<FrameCapture> getFuture() {
            return this.futureCapture;
        }

        public FrameHandler getFrameHandler() {
            return this.frameCapture;
        }

        protected void customize(EndPoint endp) {
            this.frameCapture.setEndPoint(endp);
            this.futureCapture.complete(this.frameCapture);
        }

        protected void handleException(Throwable failure) {
            this.futureCapture.completeExceptionally(failure);
            super.handleException(failure);
        }
    }
}

