/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.IO;
import org.eclipse.jetty.toolchain.test.JAR;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.javax.server.JavaxWebSocketConfiguration;
import org.eclipse.jetty.websocket.javax.tests.LocalFuzzer;
import org.eclipse.jetty.websocket.javax.tests.LocalServer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class WSServer
extends LocalServer
implements LocalFuzzer.Provider {
    private static final Logger LOG = Log.getLogger(WSServer.class);
    private final Path contextDir;
    private final String contextPath;
    private ContextHandlerCollection contexts;
    private Path webinf;
    private Path classesDir;

    public WSServer(File testdir, String contextName) {
        this(testdir.toPath(), contextName);
    }

    public WSServer(Path testdir, String contextName) {
        this.contextDir = testdir.resolve(contextName);
        this.contextPath = "/" + contextName;
        FS.ensureEmpty((Path)this.contextDir);
    }

    public void copyClass(Class<?> clazz) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String endpointPath = TypeUtil.toClassReference(clazz);
        URL classUrl = cl.getResource(endpointPath);
        MatcherAssert.assertThat((String)("Class URL for: " + clazz), (Object)classUrl, (Matcher)Matchers.notNullValue());
        Path destFile = this.classesDir.resolve(endpointPath);
        FS.ensureDirExists((Path)destFile.getParent());
        File srcFile = new File(classUrl.toURI());
        IO.copy((File)srcFile, (File)destFile.toFile());
    }

    public void copyEndpoint(Class<?> endpointClass) throws Exception {
        this.copyClass(endpointClass);
    }

    public void copyLib(Class<?> clazz, String jarFileName) throws URISyntaxException, IOException {
        this.webinf = this.contextDir.resolve("WEB-INF");
        FS.ensureDirExists((Path)this.webinf);
        Path libDir = this.webinf.resolve("lib");
        FS.ensureDirExists((Path)libDir);
        Path jarFile = libDir.resolve(jarFileName);
        URL codeSourceURL = clazz.getProtectionDomain().getCodeSource().getLocation();
        MatcherAssert.assertThat((String)"Class CodeSource URL is file scheme", (Object)codeSourceURL.getProtocol(), (Matcher)Matchers.is((Object)"file"));
        File sourceCodeSourceFile = new File(codeSourceURL.toURI());
        if (sourceCodeSourceFile.isDirectory()) {
            LOG.info("Creating " + jarFile + " from " + sourceCodeSourceFile, new Object[0]);
            JAR.create((File)sourceCodeSourceFile, (File)jarFile.toFile());
        } else {
            LOG.info("Copying " + sourceCodeSourceFile + " to " + jarFile, new Object[0]);
            IO.copy((File)sourceCodeSourceFile, (File)jarFile.toFile());
        }
    }

    public void copyWebInf(String testResourceName) throws IOException {
        this.webinf = this.contextDir.resolve("WEB-INF");
        FS.ensureDirExists((Path)this.webinf);
        this.classesDir = this.webinf.resolve("classes");
        FS.ensureDirExists((Path)this.classesDir);
        Path webxml = this.webinf.resolve("web.xml");
        File testWebXml = MavenTestingUtils.getTestResourceFile((String)testResourceName);
        IO.copy((File)testWebXml, (File)webxml.toFile());
    }

    public WebAppContext createWebAppContext() throws IOException {
        WebAppContext context = new WebAppContext();
        context.setContextPath(this.contextPath);
        context.setBaseResource((Resource)new PathResource(this.contextDir));
        context.setAttribute("org.eclipse.jetty.websocket.javax", (Object)Boolean.TRUE);
        context.addConfiguration(new Configuration[]{new AnnotationConfiguration()});
        context.addConfiguration(new Configuration[]{new PlusConfiguration()});
        context.addConfiguration(new Configuration[]{new JavaxWebSocketConfiguration()});
        return context;
    }

    public void createWebInf() throws IOException {
        this.copyWebInf("empty-web.xml");
    }

    public void deployWebapp(WebAppContext webapp) throws Exception {
        this.contexts.addHandler((Handler)webapp);
        this.contexts.manage((Object)webapp);
        webapp.setThrowUnavailableOnStartupException(true);
        webapp.start();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", new Object[]{webapp.dump()});
        }
    }

    public Path getWebAppDir() {
        return this.contextDir;
    }

    @Override
    protected Handler createRootHandler(Server server) throws Exception {
        HandlerCollection handlers = new HandlerCollection();
        this.contexts = new ContextHandlerCollection();
        return this.contexts;
    }
}

