/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ServerEndpoint(value="/")
@ClientEndpoint
public class EventSocket {
    private static final Logger LOG = Log.getLogger(EventSocket.class);
    public Session session;
    public BlockingQueue<String> messageQueue = new BlockingArrayQueue();
    public volatile Throwable error = null;
    public CountDownLatch openLatch = new CountDownLatch(1);
    public CountDownLatch closeLatch = new CountDownLatch(1);

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        LOG.info("{}  onOpen(): {}", new Object[]{this.toString(), session});
        this.openLatch.countDown();
    }

    @OnMessage
    public void onMessage(String message) throws IOException {
        LOG.info("{}  onMessage(): {}", new Object[]{this.toString(), message});
        this.messageQueue.offer(message);
    }

    @OnClose
    public void onClose(CloseReason reason) {
        LOG.info("{}  onClose(): {}", new Object[]{this.toString(), reason});
        this.closeLatch.countDown();
    }

    @OnError
    public void onError(Throwable cause) {
        LOG.info("{}  onError(): {}", new Object[]{this.toString(), cause});
        this.error = cause;
    }
}

