/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.core.server.Negotiation;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import org.eclipse.jetty.websocket.core.server.WebSocketUpgradeHandler;
import org.eclipse.jetty.websocket.javax.tests.WSURI;
import org.eclipse.jetty.websocket.javax.tests.framehandlers.FrameEcho;
import org.eclipse.jetty.websocket.javax.tests.framehandlers.WholeMessageEcho;

public class CoreServer
extends ContainerLifeCycle {
    private Server server;
    private ServerConnector connector;
    private WebSocketNegotiator negotiator;
    private URI serverUri;
    private URI wsUri;

    public CoreServer(final Function<Negotiation, FrameHandler> negotiationFunction) {
        this(new BaseNegotiator(){

            public FrameHandler negotiate(Negotiation negotiation) throws IOException {
                return (FrameHandler)negotiationFunction.apply(negotiation);
            }
        });
    }

    public CoreServer(WebSocketNegotiator negotiator) {
        this.negotiator = negotiator;
    }

    protected void doStart() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("qtp-CoreServer");
        this.server = new Server((ThreadPool)threadPool);
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)new WebSocketUpgradeHandler(this.negotiator, new String[0]));
        handlers.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlers);
        this.addBean(this.server);
        super.doStart();
        this.serverUri = this.server.getURI().resolve("/");
        this.wsUri = WSURI.toWebsocket(this.serverUri);
        super.doStart();
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public URI getWsUri() {
        return this.wsUri;
    }

    public static class EchoNegotiator
    extends BaseNegotiator {
        public FrameHandler negotiate(Negotiation negotiation) throws IOException {
            List offeredSubProtocols = negotiation.getOfferedSubprotocols();
            if (offeredSubProtocols.isEmpty()) {
                return new WholeMessageEcho();
            }
            for (String offeredSubProtocol : negotiation.getOfferedSubprotocols()) {
                if ("echo-whole".equalsIgnoreCase(offeredSubProtocol)) {
                    negotiation.setSubprotocol("echo-whole");
                    return new WholeMessageEcho();
                }
                if (!"echo-frames".equalsIgnoreCase(offeredSubProtocol)) continue;
                negotiation.setSubprotocol("echo-frames");
                return new FrameEcho();
            }
            return null;
        }

        @Override
        public void customize(FrameHandler.Configuration configurable) {
        }
    }

    public static abstract class BaseNegotiator
    implements WebSocketNegotiator {
        protected final WebSocketComponents components = new WebSocketComponents();

        public void customize(FrameHandler.Configuration configurable) {
        }

        public WebSocketExtensionRegistry getExtensionRegistry() {
            return this.components.getExtensionRegistry();
        }

        public DecoratedObjectFactory getObjectFactory() {
            return this.components.getObjectFactory();
        }

        public ByteBufferPool getByteBufferPool() {
            return this.components.getBufferPool();
        }

        public WebSocketComponents getWebSocketComponents() {
            return this.components;
        }
    }
}

