/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.server.config;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.listener.ContainerInitializer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.javax.server.internal.JavaxWebSocketServerContainer;
import org.eclipse.jetty.websocket.servlet.WebSocketMapping;
import org.eclipse.jetty.websocket.servlet.WebSocketUpgradeFilter;

@HandlesTypes(value={ServerApplicationConfig.class, ServerEndpoint.class, Endpoint.class})
public class JavaxWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    public static final String ATTR_JAVAX_SERVER_CONTAINER = ServerContainer.class.getName();
    public static final String ENABLE_KEY = "org.eclipse.jetty.websocket.javax";
    public static final String HTTPCLIENT_ATTRIBUTE = "org.eclipse.jetty.websocket.javax.HttpClient";
    private static final Logger LOG = Log.getLogger(JavaxWebSocketServletContainerInitializer.class);

    private static Boolean isEnabledViaContext(ServletContext context, String keyName) {
        String cp = context.getInitParameter(keyName);
        if (cp != null) {
            if (TypeUtil.isTrue((Object)cp)) {
                return true;
            }
            return false;
        }
        Object enable = context.getAttribute(keyName);
        if (enable != null) {
            if (TypeUtil.isTrue((Object)enable)) {
                return true;
            }
            return false;
        }
        return null;
    }

    public static void configure(ServletContextHandler context, Configurator configurator) {
        context.getServletContext().setExtendedListenerTypes(true);
        context.addEventListener((EventListener)ContainerInitializer.asContextListener((ServletContainerInitializer)new JavaxWebSocketServletContainerInitializer()).afterStartup(servletContext -> {
            JavaxWebSocketServerContainer serverContainer = JavaxWebSocketServerContainer.getContainer(servletContext);
            if (configurator != null) {
                try {
                    configurator.accept((ServletContext)servletContext, serverContainer);
                }
                catch (DeploymentException e) {
                    throw new RuntimeException("Failed to deploy WebSocket Endpoint", e);
                }
            }
        }));
    }

    public static JavaxWebSocketServerContainer initialize(ServletContextHandler context) {
        JavaxWebSocketServerContainer serverContainer = JavaxWebSocketServerContainer.getContainer((ServletContext)context.getServletContext());
        if (serverContainer == null) {
            WebSocketComponents components = WebSocketComponents.ensureWebSocketComponents((ServletContext)context.getServletContext());
            FilterHolder filterHolder = WebSocketUpgradeFilter.ensureFilter((ServletContext)context.getServletContext());
            WebSocketMapping mapping = WebSocketMapping.ensureMapping((ServletContext)context.getServletContext(), (String)"org.eclipse.jetty.websocket.servlet.WebSocketMapping");
            serverContainer = JavaxWebSocketServerContainer.ensureContainer((ServletContext)context.getServletContext());
            if (LOG.isDebugEnabled()) {
                LOG.debug("configureContext {} {} {} {}", new Object[]{mapping, components, filterHolder, serverContainer});
            }
        }
        return serverContainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        Boolean enableKey = JavaxWebSocketServletContainerInitializer.isEnabledViaContext(context, ENABLE_KEY);
        boolean websocketEnabled = true;
        if (enableKey != null) {
            websocketEnabled = enableKey;
        }
        if (!websocketEnabled) {
            LOG.info("Javax Websocket is disabled by configuration for context {}", new Object[]{context.getContextPath()});
            return;
        }
        ServletContextHandler servletContextHandler = ServletContextHandler.getServletContextHandler((ServletContext)context, (String)"Javax WebSocket SCI");
        JavaxWebSocketServerContainer container = JavaxWebSocketServletContainerInitializer.initialize(servletContextHandler);
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(context.getClassLoader());){
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} classes", (long)c.size());
            }
            HashSet<Class<? extends Endpoint>> discoveredExtendedEndpoints = new HashSet<Class<? extends Endpoint>>();
            HashSet discoveredAnnotatedEndpoints = new HashSet();
            HashSet<Class<? extends ServerApplicationConfig>> serverAppConfigs = new HashSet<Class<? extends ServerApplicationConfig>>();
            this.filterClasses(c, discoveredExtendedEndpoints, discoveredAnnotatedEndpoints, serverAppConfigs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Discovered {} extends Endpoint classes", (long)discoveredExtendedEndpoints.size());
                LOG.debug("Discovered {} @ServerEndpoint classes", (long)discoveredAnnotatedEndpoints.size());
                LOG.debug("Discovered {} ServerApplicationConfig classes", (long)serverAppConfigs.size());
            }
            boolean wasFiltered = false;
            HashSet deployableExtendedEndpointConfigs = new HashSet();
            HashSet deployableAnnotatedEndpoints = new HashSet();
            for (Class clazz : serverAppConfigs) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found ServerApplicationConfig: {}", new Object[]{clazz});
                }
                try {
                    Set annotatedClasses;
                    ServerApplicationConfig config = (ServerApplicationConfig)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Set seconfigs = config.getEndpointConfigs(discoveredExtendedEndpoints);
                    if (seconfigs != null) {
                        wasFiltered = true;
                        deployableExtendedEndpointConfigs.addAll(seconfigs);
                    }
                    if ((annotatedClasses = config.getAnnotatedEndpointClasses(discoveredAnnotatedEndpoints)) == null) continue;
                    wasFiltered = true;
                    deployableAnnotatedEndpoints.addAll(annotatedClasses);
                }
                catch (Exception e) {
                    throw new ServletException("Unable to instantiate: " + clazz.getName(), (Throwable)e);
                }
            }
            if (!wasFiltered) {
                deployableAnnotatedEndpoints.addAll(discoveredAnnotatedEndpoints);
                deployableExtendedEndpointConfigs = new HashSet();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} ServerEndpointConfig(s)", (long)deployableExtendedEndpointConfigs.size());
            }
            for (ServerEndpointConfig serverEndpointConfig : deployableExtendedEndpointConfigs) {
                try {
                    container.addEndpoint(serverEndpointConfig);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} @ServerEndpoint(s)", (long)deployableAnnotatedEndpoints.size());
            }
            for (Class clazz : deployableAnnotatedEndpoints) {
                try {
                    container.addEndpoint(clazz);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                    return;
                }
            }
        }
    }

    private void filterClasses(Set<Class<?>> c, Set<Class<? extends Endpoint>> discoveredExtendedEndpoints, Set<Class<?>> discoveredAnnotatedEndpoints, Set<Class<? extends ServerApplicationConfig>> serverAppConfigs) {
        for (Class<?> clazz : c) {
            ServerEndpoint endpoint;
            if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                serverAppConfigs.add(clazz);
            }
            if (Endpoint.class.isAssignableFrom(clazz)) {
                discoveredExtendedEndpoints.add(clazz);
            }
            if ((endpoint = clazz.getAnnotation(ServerEndpoint.class)) == null) continue;
            discoveredAnnotatedEndpoints.add(clazz);
        }
    }

    public static interface Configurator {
        public void accept(ServletContext var1, ServerContainer var2) throws DeploymentException;
    }
}

