/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.util.concurrent.Executor;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.eclipse.jetty.websocket.jsr356.JsrSessionFactory;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointScanner;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.AnnotatedServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.BasicServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.JsrCreator;
import org.eclipse.jetty.websocket.jsr356.server.JsrServerEndpointImpl;
import org.eclipse.jetty.websocket.jsr356.server.JsrServerExtendsEndpointImpl;
import org.eclipse.jetty.websocket.jsr356.server.ServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.SimpleServerEndpointMetadata;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class ServerContainer
extends ClientContainer
implements javax.websocket.server.ServerContainer {
    private static final Logger LOG = Log.getLogger(ServerContainer.class);
    private final NativeWebSocketConfiguration configuration;

    public ServerContainer(NativeWebSocketConfiguration nativeWebSocketConfiguration, Executor executor) {
        super(executor);
        this.configuration = nativeWebSocketConfiguration;
        EventDriverFactory eventDriverFactory = this.configuration.getFactory().getEventDriverFactory();
        eventDriverFactory.addImplementation((EventDriverImpl)new JsrServerEndpointImpl());
        eventDriverFactory.addImplementation((EventDriverImpl)new JsrServerExtendsEndpointImpl());
        this.configuration.getFactory().addSessionFactory((SessionFactory)new JsrSessionFactory((ClientContainer)this, new SessionListener[]{this}));
    }

    public EndpointInstance newClientEndpointInstance(Object endpoint, ServerEndpointConfig config, String path) {
        EndpointMetadata metadata = this.getClientEndpointMetadata(endpoint.getClass(), (EndpointConfig)config);
        Object cec = config;
        if (config == null) {
            cec = metadata instanceof AnnotatedServerEndpointMetadata ? ((AnnotatedServerEndpointMetadata)metadata).getConfig() : new BasicServerEndpointConfig(endpoint.getClass(), path);
        }
        return new EndpointInstance(endpoint, (EndpointConfig)cec, metadata);
    }

    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        ServerEndpointMetadata metadata = this.getServerEndpointMetadata(endpointClass, null);
        this.addEndpoint(metadata);
    }

    public void addEndpoint(ServerEndpointMetadata metadata) throws DeploymentException {
        JsrCreator creator = new JsrCreator(metadata, this.configuration.getFactory().getExtensionFactory());
        this.configuration.addMapping((PathSpec)new UriTemplatePathSpec(metadata.getPath()), (WebSocketCreator)creator);
    }

    public void addEndpoint(ServerEndpointConfig config) throws DeploymentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addEndpoint({}) path={} endpoint={}", new Object[]{config, config.getPath(), config.getEndpointClass()});
        }
        ServerEndpointMetadata metadata = this.getServerEndpointMetadata(config.getEndpointClass(), config);
        this.addEndpoint(metadata);
    }

    public ServerEndpointMetadata getServerEndpointMetadata(Class<?> endpoint, ServerEndpointConfig config) throws DeploymentException {
        ServerEndpointMetadata metadata = null;
        ServerEndpoint anno = endpoint.getAnnotation(ServerEndpoint.class);
        if (anno != null) {
            AnnotatedServerEndpointMetadata ametadata = new AnnotatedServerEndpointMetadata(endpoint, config);
            AnnotatedEndpointScanner scanner = new AnnotatedEndpointScanner((AnnotatedEndpointMetadata)ametadata);
            metadata = ametadata;
            scanner.scan();
        } else if (Endpoint.class.isAssignableFrom(endpoint)) {
            Class<?> eendpoint = endpoint;
            metadata = new SimpleServerEndpointMetadata(eendpoint, config);
        } else {
            StringBuilder err = new StringBuilder();
            err.append("Not a recognized websocket [");
            err.append(endpoint.getName());
            err.append("] does not extend @").append(ServerEndpoint.class.getName());
            err.append(" or extend from ").append(Endpoint.class.getName());
            throw new DeploymentException("Unable to identify as valid Endpoint: " + endpoint);
        }
        return metadata;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.configuration.getPolicy().getAsyncWriteTimeout();
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.configuration.getPolicy().getMaxBinaryMessageSize();
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.configuration.getPolicy().getIdleTimeout();
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.configuration.getPolicy().getMaxTextMessageSize();
    }

    public void setAsyncSendTimeout(long ms) {
        super.setAsyncSendTimeout(ms);
        this.configuration.getPolicy().setAsyncWriteTimeout(ms);
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        super.setDefaultMaxBinaryMessageBufferSize(max);
        this.configuration.getPolicy().setMaxBinaryMessageSize(max);
        this.configuration.getPolicy().setMaxBinaryMessageBufferSize(max);
    }

    public void setDefaultMaxSessionIdleTimeout(long ms) {
        super.setDefaultMaxSessionIdleTimeout(ms);
        this.configuration.getPolicy().setIdleTimeout(ms);
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        super.setDefaultMaxTextMessageBufferSize(max);
        this.configuration.getPolicy().setMaxTextMessageSize(max);
        this.configuration.getPolicy().setMaxTextMessageBufferSize(max);
    }
}

