/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.messages.AbstractMessageSink;
import org.eclipse.jetty.websocket.javax.common.util.InvalidSignatureException;

public class PartialByteArrayMessageSink
extends AbstractMessageSink {
    public PartialByteArrayMessageSink(JavaxWebSocketSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
        Objects.requireNonNull(methodHandle, "MethodHandle");
        MethodType onMessageType = MethodType.methodType(Void.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        if (methodHandle.type() != onMessageType) {
            throw InvalidSignatureException.build(onMessageType, methodHandle.type());
        }
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            byte[] buffer;
            int offset = 0;
            int length = 0;
            if (frame.hasPayload()) {
                ByteBuffer payload = frame.getPayload();
                length = payload.remaining();
                buffer = BufferUtil.toArray((ByteBuffer)payload);
            } else {
                buffer = new byte[]{};
            }
            this.methodHandle.invoke(buffer, offset, length, frame.isFin());
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
    }
}

