/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.Session;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSessionListener;

public class SessionTracker
extends AbstractLifeCycle
implements JavaxWebSocketSessionListener {
    private CopyOnWriteArraySet<JavaxWebSocketSession> sessions = new CopyOnWriteArraySet();

    public Set<Session> getSessions() {
        return Collections.unmodifiableSet(this.sessions);
    }

    @Override
    public void onJavaxWebSocketSessionOpened(JavaxWebSocketSession session) {
        this.sessions.add(session);
    }

    @Override
    public void onJavaxWebSocketSessionClosed(JavaxWebSocketSession session) {
        this.sessions.remove((Object)session);
    }

    protected void doStop() throws Exception {
        for (JavaxWebSocketSession session : this.sessions) {
            LifeCycle.stop((Object)((Object)session));
        }
        super.doStop();
    }
}

