/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.ProtocolException;
import org.eclipse.jetty.websocket.core.WebSocketException;
import org.eclipse.jetty.websocket.javax.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketPongMessage;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.MessageSink;
import org.eclipse.jetty.websocket.javax.common.RegisteredMessageHandler;
import org.eclipse.jetty.websocket.javax.common.UpgradeRequest;
import org.eclipse.jetty.websocket.javax.common.UpgradeResponse;
import org.eclipse.jetty.websocket.javax.common.decoders.AvailableDecoders;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedBinaryMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedBinaryStreamMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedTextMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedTextStreamMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.PartialByteArrayMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.PartialByteBufferMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.PartialStringMessageSink;
import org.eclipse.jetty.websocket.javax.common.util.InvokerUtils;

public class JavaxWebSocketFrameHandler
implements FrameHandler {
    private final Logger logger;
    private final JavaxWebSocketContainer container;
    private final Object endpointInstance;
    private MethodHandle openHandle;
    private MethodHandle closeHandle;
    private MethodHandle errorHandle;
    private JavaxWebSocketFrameHandlerMetadata.MessageMetadata textMetadata;
    private JavaxWebSocketFrameHandlerMetadata.MessageMetadata binaryMetadata;
    private MethodHandle pongHandle;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;
    private final EndpointConfig endpointConfig;
    private MessageSink textSink;
    private MessageSink binarySink;
    private MessageSink activeMessageSink;
    private JavaxWebSocketSession session;
    private Map<Byte, RegisteredMessageHandler> messageHandlerMap;
    private FrameHandler.CoreSession coreSession;
    protected byte dataType = (byte)-1;

    public JavaxWebSocketFrameHandler(JavaxWebSocketContainer container, Object endpointInstance, MethodHandle openHandle, MethodHandle closeHandle, MethodHandle errorHandle, JavaxWebSocketFrameHandlerMetadata.MessageMetadata textMetadata, JavaxWebSocketFrameHandlerMetadata.MessageMetadata binaryMetadata, MethodHandle pongHandle, EndpointConfig endpointConfig) {
        this.logger = Log.getLogger(endpointInstance.getClass());
        this.container = container;
        if (endpointInstance instanceof ConfiguredEndpoint) {
            RuntimeException oops = new RuntimeException("ConfiguredEndpoint needs to be unwrapped");
            this.logger.warn((Throwable)oops);
            throw oops;
        }
        this.endpointInstance = endpointInstance;
        this.openHandle = openHandle;
        this.closeHandle = closeHandle;
        this.errorHandle = errorHandle;
        this.textMetadata = textMetadata;
        this.binaryMetadata = binaryMetadata;
        this.pongHandle = pongHandle;
        this.endpointConfig = endpointConfig;
        this.messageHandlerMap = new HashMap<Byte, RegisteredMessageHandler>();
    }

    public Object getEndpoint() {
        return this.endpointInstance;
    }

    public EndpointConfig getEndpointConfig() {
        return this.endpointConfig;
    }

    public JavaxWebSocketSession getSession() {
        return this.session;
    }

    public void onOpen(FrameHandler.CoreSession coreSession, Callback callback) {
        try {
            this.coreSession = coreSession;
            this.session = new JavaxWebSocketSession(this.container, coreSession, this, this.endpointConfig);
            this.openHandle = InvokerUtils.bindTo(this.openHandle, new Object[]{this.session, this.endpointConfig});
            this.closeHandle = InvokerUtils.bindTo(this.closeHandle, new Object[]{this.session});
            this.errorHandle = InvokerUtils.bindTo(this.errorHandle, new Object[]{this.session});
            JavaxWebSocketFrameHandlerMetadata.MessageMetadata actualTextMetadata = JavaxWebSocketFrameHandlerMetadata.MessageMetadata.copyOf(this.textMetadata);
            JavaxWebSocketFrameHandlerMetadata.MessageMetadata actualBinaryMetadata = JavaxWebSocketFrameHandlerMetadata.MessageMetadata.copyOf(this.binaryMetadata);
            this.pongHandle = InvokerUtils.bindTo(this.pongHandle, new Object[]{this.session});
            if (actualTextMetadata != null) {
                if (actualTextMetadata.isMaxMessageSizeSet()) {
                    this.session.setMaxTextMessageBufferSize(actualTextMetadata.maxMessageSize);
                }
                actualTextMetadata.handle = InvokerUtils.bindTo(actualTextMetadata.handle, new Object[]{this.endpointInstance, this.endpointConfig, this.session});
                actualTextMetadata.handle = JavaxWebSocketFrameHandlerFactory.wrapNonVoidReturnType(actualTextMetadata.handle, this.session);
                this.textSink = JavaxWebSocketFrameHandlerFactory.createMessageSink(this.session, actualTextMetadata);
                this.textMetadata = actualTextMetadata;
            }
            if (actualBinaryMetadata != null) {
                if (actualBinaryMetadata.isMaxMessageSizeSet()) {
                    this.session.setMaxBinaryMessageBufferSize(actualBinaryMetadata.maxMessageSize);
                }
                actualBinaryMetadata.handle = InvokerUtils.bindTo(actualBinaryMetadata.handle, new Object[]{this.endpointInstance, this.endpointConfig, this.session});
                actualBinaryMetadata.handle = JavaxWebSocketFrameHandlerFactory.wrapNonVoidReturnType(actualBinaryMetadata.handle, this.session);
                this.binarySink = JavaxWebSocketFrameHandlerFactory.createMessageSink(this.session, actualBinaryMetadata);
                this.binaryMetadata = actualBinaryMetadata;
            }
            if (this.openHandle != null) {
                this.openHandle.invoke();
            }
            this.container.notifySessionListeners(listener -> listener.onJavaxWebSocketSessionOpened(this.session));
            callback.succeeded();
        }
        catch (Throwable cause) {
            WebSocketException wse = new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " OPEN method error: " + cause.getMessage(), cause);
            callback.failed((Throwable)wse);
        }
    }

    public void onFrame(Frame frame, Callback callback) {
        switch (frame.getOpCode()) {
            case 1: {
                this.dataType = 1;
                this.onText(frame, callback);
                break;
            }
            case 2: {
                this.dataType = (byte)2;
                this.onBinary(frame, callback);
                break;
            }
            case 0: {
                this.onContinuation(frame, callback);
                break;
            }
            case 9: {
                this.onPing(frame, callback);
                break;
            }
            case 10: {
                this.onPong(frame, callback);
                break;
            }
            case 8: {
                this.onClose(frame, callback);
                break;
            }
            default: {
                callback.failed((Throwable)new IllegalStateException());
            }
        }
        if (frame.isFin() && !frame.isControlFrame()) {
            this.dataType = (byte)-1;
        }
    }

    public void onClosed(CloseStatus closeStatus, Callback callback) {
        try {
            if (this.closeHandle != null) {
                CloseReason closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode((int)closeStatus.getCode()), closeStatus.getReason());
                this.closeHandle.invoke(closeReason);
            }
            callback.succeeded();
        }
        catch (Throwable cause) {
            callback.failed((Throwable)new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " CLOSE method error: " + cause.getMessage(), cause));
        }
        this.container.notifySessionListeners(listener -> listener.onJavaxWebSocketSessionClosed(this.session));
    }

    public void onError(Throwable cause, Callback callback) {
        try {
            if (this.errorHandle != null) {
                this.errorHandle.invoke(cause);
            } else {
                this.logger.warn("Unhandled Error: " + this.endpointInstance, cause);
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            WebSocketException wsError = new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " ERROR method error: " + cause.getMessage(), t);
            wsError.addSuppressed(cause);
            callback.failed((Throwable)wsError);
        }
    }

    public Set<MessageHandler> getMessageHandlers() {
        if (this.messageHandlerMap.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.messageHandlerMap.values().stream().map(rh -> rh.getMessageHandler()).collect(Collectors.toSet()));
    }

    public Map<Byte, RegisteredMessageHandler> getMessageHandlerMap() {
        return this.messageHandlerMap;
    }

    public JavaxWebSocketFrameHandlerMetadata.MessageMetadata getBinaryMetadata() {
        return this.binaryMetadata;
    }

    public JavaxWebSocketFrameHandlerMetadata.MessageMetadata getTextMetadata() {
        return this.textMetadata;
    }

    private void assertBasicTypeNotRegistered(byte basicWebSocketType, Object messageImpl, String replacement) {
        if (messageImpl != null) {
            throw new IllegalStateException("Cannot register " + replacement + ": Basic WebSocket type " + OpCode.name((byte)basicWebSocketType) + " is already registered");
        }
    }

    public <T> void addMessageHandler(JavaxWebSocketSession session, Class<T> clazz, MessageHandler.Partial<T> handler) {
        block6: {
            try {
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodHandle partialMessageHandler = lookup.findVirtual(MessageHandler.Partial.class, "onMessage", MethodType.methodType(Void.TYPE, Object.class, Boolean.TYPE));
                partialMessageHandler = partialMessageHandler.bindTo(handler);
                if (byte[].class.isAssignableFrom(clazz)) {
                    this.assertBasicTypeNotRegistered((byte)2, this.binaryMetadata, handler.getClass().getName());
                    PartialByteArrayMessageSink messageSink = new PartialByteArrayMessageSink(session, partialMessageHandler);
                    this.binarySink = this.registerMessageHandler((byte)2, clazz, (MessageHandler)handler, messageSink);
                    JavaxWebSocketFrameHandlerMetadata.MessageMetadata metadata = new JavaxWebSocketFrameHandlerMetadata.MessageMetadata();
                    metadata.handle = partialMessageHandler;
                    metadata.sinkClass = PartialByteArrayMessageSink.class;
                    this.binaryMetadata = metadata;
                    break block6;
                }
                if (ByteBuffer.class.isAssignableFrom(clazz)) {
                    this.assertBasicTypeNotRegistered((byte)2, this.binaryMetadata, handler.getClass().getName());
                    PartialByteBufferMessageSink messageSink = new PartialByteBufferMessageSink(session, partialMessageHandler);
                    this.binarySink = this.registerMessageHandler((byte)2, clazz, (MessageHandler)handler, messageSink);
                    JavaxWebSocketFrameHandlerMetadata.MessageMetadata metadata = new JavaxWebSocketFrameHandlerMetadata.MessageMetadata();
                    metadata.handle = partialMessageHandler;
                    metadata.sinkClass = PartialByteBufferMessageSink.class;
                    this.binaryMetadata = metadata;
                    break block6;
                }
                if (String.class.isAssignableFrom(clazz)) {
                    this.assertBasicTypeNotRegistered((byte)1, this.textMetadata, handler.getClass().getName());
                    PartialStringMessageSink messageSink = new PartialStringMessageSink(session, partialMessageHandler);
                    this.textSink = this.registerMessageHandler((byte)1, clazz, (MessageHandler)handler, messageSink);
                    JavaxWebSocketFrameHandlerMetadata.MessageMetadata metadata = new JavaxWebSocketFrameHandlerMetadata.MessageMetadata();
                    metadata.handle = partialMessageHandler;
                    metadata.sinkClass = PartialStringMessageSink.class;
                    this.textMetadata = metadata;
                    break block6;
                }
                throw new RuntimeException("Unable to add " + handler.getClass().getName() + " with type " + clazz + ": only supported types byte[], " + ByteBuffer.class.getName() + ", " + String.class.getName());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Unable to find method", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to access " + handler.getClass().getName(), e);
            }
        }
    }

    public <T> void addMessageHandler(JavaxWebSocketSession session, Class<T> clazz, MessageHandler.Whole<T> handler) {
        block9: {
            try {
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodHandle wholeMsgMethodHandle = lookup.findVirtual(MessageHandler.Whole.class, "onMessage", MethodType.methodType(Void.TYPE, Object.class));
                wholeMsgMethodHandle = wholeMsgMethodHandle.bindTo(handler);
                if (PongMessage.class.isAssignableFrom(clazz)) {
                    this.assertBasicTypeNotRegistered((byte)10, this.pongHandle, handler.getClass().getName());
                    this.pongHandle = wholeMsgMethodHandle;
                    this.registerMessageHandler((byte)10, clazz, (MessageHandler)handler, null);
                    break block9;
                }
                AvailableDecoders availableDecoders = session.getDecoders();
                AvailableDecoders.RegisteredDecoder registeredDecoder = availableDecoders.getRegisteredDecoderFor(clazz);
                if (registeredDecoder == null) {
                    throw new IllegalStateException("Unable to find Decoder for type: " + clazz);
                }
                JavaxWebSocketFrameHandlerMetadata.MessageMetadata metadata = new JavaxWebSocketFrameHandlerMetadata.MessageMetadata();
                metadata.handle = wholeMsgMethodHandle;
                metadata.registeredDecoder = registeredDecoder;
                if (registeredDecoder.implementsInterface(Decoder.Binary.class)) {
                    this.assertBasicTypeNotRegistered((byte)2, this.binaryMetadata, handler.getClass().getName());
                    Decoder.Binary decoder = (Decoder.Binary)availableDecoders.getInstanceOf(registeredDecoder);
                    DecodedBinaryMessageSink messageSink = new DecodedBinaryMessageSink(session, decoder, wholeMsgMethodHandle);
                    metadata.sinkClass = messageSink.getClass();
                    this.binarySink = this.registerMessageHandler((byte)2, clazz, (MessageHandler)handler, messageSink);
                    this.binaryMetadata = metadata;
                    break block9;
                }
                if (registeredDecoder.implementsInterface(Decoder.BinaryStream.class)) {
                    this.assertBasicTypeNotRegistered((byte)2, this.binaryMetadata, handler.getClass().getName());
                    Decoder.BinaryStream decoder = (Decoder.BinaryStream)availableDecoders.getInstanceOf(registeredDecoder);
                    DecodedBinaryStreamMessageSink messageSink = new DecodedBinaryStreamMessageSink(session, decoder, wholeMsgMethodHandle);
                    metadata.sinkClass = messageSink.getClass();
                    this.binarySink = this.registerMessageHandler((byte)2, clazz, (MessageHandler)handler, messageSink);
                    this.binaryMetadata = metadata;
                    break block9;
                }
                if (registeredDecoder.implementsInterface(Decoder.Text.class)) {
                    this.assertBasicTypeNotRegistered((byte)1, this.textMetadata, handler.getClass().getName());
                    Decoder.Text decoder = (Decoder.Text)availableDecoders.getInstanceOf(registeredDecoder);
                    DecodedTextMessageSink messageSink = new DecodedTextMessageSink(session, decoder, wholeMsgMethodHandle);
                    metadata.sinkClass = messageSink.getClass();
                    this.textSink = this.registerMessageHandler((byte)1, clazz, (MessageHandler)handler, messageSink);
                    this.textMetadata = metadata;
                    break block9;
                }
                if (registeredDecoder.implementsInterface(Decoder.TextStream.class)) {
                    this.assertBasicTypeNotRegistered((byte)1, this.textMetadata, handler.getClass().getName());
                    Decoder.TextStream decoder = (Decoder.TextStream)availableDecoders.getInstanceOf(registeredDecoder);
                    DecodedTextStreamMessageSink messageSink = new DecodedTextStreamMessageSink(session, decoder, wholeMsgMethodHandle);
                    metadata.sinkClass = messageSink.getClass();
                    this.textSink = this.registerMessageHandler((byte)1, clazz, (MessageHandler)handler, messageSink);
                    this.textMetadata = metadata;
                    break block9;
                }
                throw new RuntimeException("Unable to add " + handler.getClass().getName() + ": type " + clazz + " is unrecognized by declared decoders");
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Unable to find method", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to access " + handler.getClass().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> MessageSink registerMessageHandler(byte basicWebSocketMessageType, Class<T> handlerType, MessageHandler handler, MessageSink messageSink) {
        Map<Byte, RegisteredMessageHandler> map = this.messageHandlerMap;
        synchronized (map) {
            RegisteredMessageHandler registeredHandler = this.messageHandlerMap.get(basicWebSocketMessageType);
            if (registeredHandler != null) {
                throw new IllegalStateException(String.format("Cannot register %s: Basic WebSocket type %s is already registered to %s", handler.getClass().getName(), OpCode.name((byte)basicWebSocketMessageType), registeredHandler.getMessageHandler().getClass().getName()));
            }
            registeredHandler = new RegisteredMessageHandler(basicWebSocketMessageType, handlerType, handler);
            this.getMessageHandlerMap().put(registeredHandler.getWebsocketMessageType(), registeredHandler);
            return messageSink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler handler) {
        Map<Byte, RegisteredMessageHandler> map = this.messageHandlerMap;
        synchronized (map) {
            Optional<Map.Entry> optionalEntry = this.messageHandlerMap.entrySet().stream().filter(entry -> ((RegisteredMessageHandler)entry.getValue()).getMessageHandler().equals(handler)).findFirst();
            if (optionalEntry.isPresent()) {
                byte key = (Byte)optionalEntry.get().getKey();
                this.messageHandlerMap.remove(key);
                switch (key) {
                    case 10: {
                        this.pongHandle = null;
                        break;
                    }
                    case 1: {
                        this.textMetadata = null;
                        this.textSink = null;
                        break;
                    }
                    case 2: {
                        this.binaryMetadata = null;
                        this.binarySink = null;
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getClass().getSimpleName());
        ret.append('@').append(Integer.toHexString(this.hashCode()));
        ret.append("[endpoint=");
        if (this.endpointInstance == null) {
            ret.append("<null>");
        } else {
            ret.append(this.endpointInstance.getClass().getName());
        }
        ret.append(']');
        return ret.toString();
    }

    private void acceptMessage(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            callback.succeeded();
            return;
        }
        this.activeMessageSink.accept(frame, callback);
        if (frame.isFin()) {
            this.activeMessageSink = null;
        }
    }

    public void onClose(Frame frame, Callback callback) {
        callback.succeeded();
    }

    public void onPing(Frame frame, Callback callback) {
        ByteBuffer payload = BufferUtil.copy((ByteBuffer)frame.getPayload());
        this.coreSession.sendFrame(new Frame(10).setPayload(payload), Callback.NOOP, false);
        callback.succeeded();
    }

    public void onPong(Frame frame, Callback callback) {
        if (this.pongHandle != null) {
            try {
                ByteBuffer payload = frame.getPayload();
                if (payload == null) {
                    payload = BufferUtil.EMPTY_BUFFER;
                }
                JavaxWebSocketPongMessage pongMessage = new JavaxWebSocketPongMessage(payload);
                this.pongHandle.invoke(pongMessage);
            }
            catch (Throwable cause) {
                throw new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " PONG method error: " + cause.getMessage(), cause);
            }
        }
        callback.succeeded();
    }

    public void onText(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            this.activeMessageSink = this.textSink;
        }
        this.acceptMessage(frame, callback);
    }

    public void onBinary(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            this.activeMessageSink = this.binarySink;
        }
        this.acceptMessage(frame, callback);
    }

    public void onContinuation(Frame frame, Callback callback) {
        switch (this.dataType) {
            case 1: {
                this.onText(frame, callback);
                break;
            }
            case 2: {
                this.onBinary(frame, callback);
                break;
            }
            default: {
                throw new ProtocolException("Unable to process continuation during dataType " + this.dataType);
            }
        }
    }

    public void setUpgradeRequest(UpgradeRequest upgradeRequest) {
        this.upgradeRequest = upgradeRequest;
    }

    public void setUpgradeResponse(UpgradeResponse upgradeResponse) {
        this.upgradeResponse = upgradeResponse;
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }
}

