/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.client;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.javax.client.AnnotatedClientEndpointConfig;
import org.eclipse.jetty.websocket.javax.client.EmptyClientEndpointConfig;
import org.eclipse.jetty.websocket.javax.client.JavaxClientUpgradeRequest;
import org.eclipse.jetty.websocket.javax.client.JavaxWebSocketClientFrameHandlerFactory;
import org.eclipse.jetty.websocket.javax.client.JsrUpgradeListener;
import org.eclipse.jetty.websocket.javax.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.javax.common.InvalidWebSocketException;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketExtensionConfig;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandler;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerFactory;

@ManagedObject(value="JSR356 Client Container")
public class JavaxWebSocketClientContainer
extends JavaxWebSocketContainer
implements WebSocketContainer {
    protected WebSocketCoreClient coreClient;
    protected Function<WebSocketComponents, WebSocketCoreClient> coreClientFactory;
    private final JavaxWebSocketClientFrameHandlerFactory frameHandlerFactory;

    public JavaxWebSocketClientContainer() {
        this(new WebSocketComponents());
    }

    public JavaxWebSocketClientContainer(HttpClient httpClient) {
        this(new WebSocketComponents(), wsComponents -> {
            WebSocketCoreClient coreClient = new WebSocketCoreClient(httpClient, wsComponents);
            coreClient.getHttpClient().setName("Javax-WebSocketClient@" + Integer.toHexString(coreClient.getHttpClient().hashCode()));
            return coreClient;
        });
    }

    public JavaxWebSocketClientContainer(WebSocketComponents components) {
        this(components, wsComponents -> {
            WebSocketCoreClient coreClient = new WebSocketCoreClient(wsComponents);
            coreClient.getHttpClient().setName("Javax-WebSocketClient@" + Integer.toHexString(coreClient.getHttpClient().hashCode()));
            return coreClient;
        });
    }

    public JavaxWebSocketClientContainer(WebSocketComponents components, Function<WebSocketComponents, WebSocketCoreClient> coreClientFactory) {
        super(components);
        this.coreClientFactory = coreClientFactory;
        this.frameHandlerFactory = new JavaxWebSocketClientFrameHandlerFactory(this);
    }

    protected HttpClient getHttpClient() {
        return this.getWebSocketCoreClient().getHttpClient();
    }

    protected WebSocketCoreClient getWebSocketCoreClient() {
        if (this.coreClient == null) {
            this.coreClient = this.coreClientFactory.apply(this.components);
            this.addManaged((LifeCycle)this.coreClient);
        }
        return this.coreClient;
    }

    private CompletableFuture<Session> connect(JavaxClientUpgradeRequest upgradeRequest) {
        upgradeRequest.setConfiguration(this.defaultCustomizer);
        CompletableFuture<Session> futureSession = new CompletableFuture<Session>();
        try {
            WebSocketCoreClient coreClient = this.getWebSocketCoreClient();
            coreClient.connect((ClientUpgradeRequest)upgradeRequest).whenComplete((coreSession, error) -> {
                if (error != null) {
                    futureSession.completeExceptionally((Throwable)error);
                    return;
                }
                JavaxWebSocketFrameHandler frameHandler = (JavaxWebSocketFrameHandler)upgradeRequest.getFrameHandler();
                futureSession.complete((Session)frameHandler.getSession());
            });
        }
        catch (Exception e) {
            futureSession.completeExceptionally(e);
        }
        return futureSession;
    }

    private Session connect(ConfiguredEndpoint configuredEndpoint, URI destURI) throws IOException {
        Objects.requireNonNull(configuredEndpoint, "WebSocket configured endpoint cannot be null");
        Objects.requireNonNull(destURI, "Destination URI cannot be null");
        JavaxClientUpgradeRequest upgradeRequest = new JavaxClientUpgradeRequest(this, this.getWebSocketCoreClient(), destURI, configuredEndpoint);
        EndpointConfig config = configuredEndpoint.getConfig();
        if (config instanceof ClientEndpointConfig) {
            ClientEndpointConfig clientEndpointConfig = (ClientEndpointConfig)config;
            JsrUpgradeListener jsrUpgradeListener = new JsrUpgradeListener(clientEndpointConfig.getConfigurator());
            upgradeRequest.addListener(jsrUpgradeListener);
            for (Extension ext : clientEndpointConfig.getExtensions()) {
                upgradeRequest.addExtensions(new ExtensionConfig[]{new JavaxWebSocketExtensionConfig(ext)});
            }
            if (clientEndpointConfig.getPreferredSubprotocols().size() > 0) {
                upgradeRequest.setSubProtocols(clientEndpointConfig.getPreferredSubprotocols());
            }
        }
        long timeout = this.getWebSocketCoreClient().getHttpClient().getConnectTimeout();
        try {
            CompletableFuture<Session> sessionFuture = this.connect(upgradeRequest);
            if (timeout > 0L) {
                return (Session)sessionFuture.get(timeout + 1000L, TimeUnit.MILLISECONDS);
            }
            return (Session)sessionFuture.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (TimeoutException e) {
            throw new IOException("Connection future timeout " + timeout + " ms for " + destURI, e);
        }
        catch (Throwable e) {
            throw new IOException("Unable to connect to " + destURI, e);
        }
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig config, URI path) throws IOException {
        ClientEndpointConfig clientEndpointConfig = config;
        if (clientEndpointConfig == null) {
            clientEndpointConfig = new EmptyClientEndpointConfig();
        }
        ConfiguredEndpoint instance = this.newConfiguredEndpoint(endpointClass, (EndpointConfig)clientEndpointConfig);
        return this.connect(instance, path);
    }

    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws IOException {
        ConfiguredEndpoint instance = this.newConfiguredEndpoint(annotatedEndpointClass, (EndpointConfig)new EmptyClientEndpointConfig());
        return this.connect(instance, path);
    }

    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        ClientEndpointConfig clientEndpointConfig = config;
        if (clientEndpointConfig == null) {
            clientEndpointConfig = new EmptyClientEndpointConfig();
        }
        ConfiguredEndpoint instance = this.newConfiguredEndpoint(endpoint, (EndpointConfig)clientEndpointConfig);
        return this.connect(instance, path);
    }

    public Session connectToServer(Object endpoint, URI path) throws DeploymentException, IOException {
        ConfiguredEndpoint instance = this.newConfiguredEndpoint(endpoint, (EndpointConfig)new EmptyClientEndpointConfig());
        return this.connect(instance, path);
    }

    public JavaxWebSocketFrameHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    public Executor getExecutor() {
        return this.getHttpClient().getExecutor();
    }

    private ConfiguredEndpoint newConfiguredEndpoint(Class<?> endpointClass, EndpointConfig config) {
        try {
            return this.newConfiguredEndpoint(endpointClass.getConstructor(new Class[0]).newInstance(new Object[0]), config);
        }
        catch (Throwable e) {
            throw new InvalidWebSocketException("Unable to instantiate websocket: " + endpointClass.getName());
        }
    }

    public ConfiguredEndpoint newConfiguredEndpoint(Object endpoint, EndpointConfig providedConfig) throws DeploymentException {
        EndpointConfig config = providedConfig;
        if (config == null) {
            config = this.newEmptyConfig(endpoint);
        }
        config = this.readAnnotatedConfig(endpoint, config);
        return new ConfiguredEndpoint(endpoint, config);
    }

    protected EndpointConfig newEmptyConfig(Object endpoint) {
        return new EmptyClientEndpointConfig();
    }

    protected EndpointConfig readAnnotatedConfig(Object endpoint, EndpointConfig config) throws DeploymentException {
        ClientEndpoint anno = endpoint.getClass().getAnnotation(ClientEndpoint.class);
        if (anno != null) {
            return new AnnotatedClientEndpointConfig(anno);
        }
        return config;
    }
}

