/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.client;

import java.net.URI;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.javax.client.DelegatedJavaxClientUpgradeRequest;
import org.eclipse.jetty.websocket.javax.client.DelegatedJavaxClientUpgradeResponse;
import org.eclipse.jetty.websocket.javax.client.JavaxWebSocketClientContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandler;
import org.eclipse.jetty.websocket.javax.common.UpgradeRequest;
import org.eclipse.jetty.websocket.javax.common.UpgradeResponse;

public class JavaxClientUpgradeRequest
extends ClientUpgradeRequest {
    private final JavaxWebSocketClientContainer containerContext;
    private final JavaxWebSocketFrameHandler frameHandler;

    public JavaxClientUpgradeRequest(JavaxWebSocketClientContainer clientContainer, WebSocketCoreClient coreClient, URI requestURI, Object websocketPojo) {
        super(coreClient, requestURI);
        this.containerContext = clientContainer;
        DelegatedJavaxClientUpgradeRequest upgradeRequest = new DelegatedJavaxClientUpgradeRequest(this);
        this.frameHandler = this.containerContext.newFrameHandler(websocketPojo, upgradeRequest);
    }

    public void upgrade(HttpResponse response, HttpConnectionOverHTTP httpConnection) {
        this.frameHandler.setUpgradeRequest((UpgradeRequest)new DelegatedJavaxClientUpgradeRequest(this));
        this.frameHandler.setUpgradeResponse((UpgradeResponse)new DelegatedJavaxClientUpgradeResponse(response));
        super.upgrade(response, httpConnection);
    }

    public FrameHandler getFrameHandler() {
        return this.frameHandler;
    }
}

