/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xslt.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;

public class SourceFetchExtension {
    public static int bufferSize = 65536;

    public static String fetch(String location) throws Exception {
        System.out.println("Fetch: " + location.trim());
        URL url = new URL(location);
        return SourceFetchExtension.toString(url.openStream());
    }

    public static String toString(InputStream in) throws IOException {
        return SourceFetchExtension.toString(in, null);
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        SourceFetchExtension.copy(reader, writer);
        return writer.toString();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        SourceFetchExtension.copy(in, out, -1L);
    }

    public static void copy(Reader in, Writer out) throws IOException {
        SourceFetchExtension.copy(in, out, -1L);
    }

    public static void copy(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            int max;
            while (byteCount > 0L && (len = in.read(buffer, 0, max = byteCount < (long)bufferSize ? (int)byteCount : bufferSize)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out, long byteCount) throws IOException {
        char[] buffer = new char[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else if (out instanceof PrintWriter) {
            PrintWriter pout = (PrintWriter)out;
            while (!pout.checkError() && (len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }
}

