/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.toolchain.version.issues.IssueSyntax;

public class IssuePatterns {
    private List<Entry> list = new ArrayList<Entry>();

    public void add(IssueSyntax type, String regex) {
        Entry entry = new Entry();
        entry.syntax = type;
        entry.pattern = Pattern.compile(regex, 2);
        this.list.add(entry);
    }

    public Match find(String line) {
        for (Entry entry : this.list) {
            Matcher mat = entry.pattern.matcher(line);
            if (!mat.find()) continue;
            Match ret = new Match();
            ret.matcher = mat;
            ret.syntax = entry.syntax;
            return ret;
        }
        return null;
    }

    private class Entry {
        IssueSyntax syntax;
        Pattern pattern;

        private Entry() {
        }
    }

    public class Match {
        private Matcher matcher;
        public IssueSyntax syntax;

        public String group(int group) {
            return this.matcher.group(group);
        }

        public int end() {
            return this.matcher.end();
        }
    }
}

