/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionPattern {
    public static final VersionPattern ECLIPSE = new VersionPattern("jetty-VERSION");
    public static final VersionPattern CODEHAUS = new VersionPattern("jetty@codehaus-VERSION");
    private final String key;
    private final Pattern pat;
    private String lastVersion;
    private String remainingText;

    public VersionPattern(String key) {
        this.key = key;
        String regex = key.replace("-", "[- ]").replace("VERSION", "([1-9]\\.[0-9]{1,}[^ ]*)");
        this.pat = Pattern.compile("^" + regex, 2);
    }

    public String getLastVersion() {
        if (this.lastVersion == null) {
            return null;
        }
        return this.key.replace("VERSION", this.lastVersion);
    }

    public String getLastVersion(String altkey) {
        if (this.lastVersion == null) {
            return null;
        }
        return altkey.replace("VERSION", this.lastVersion);
    }

    public String getRemainingText() {
        return this.remainingText;
    }

    public boolean isMatch(String str) {
        Matcher mat = this.pat.matcher(str);
        if (mat.find()) {
            this.remainingText = str.substring(mat.end());
            this.lastVersion = mat.group(1);
            return true;
        }
        this.remainingText = null;
        this.lastVersion = null;
        return false;
    }

    public String toVersionId(String version) {
        return this.key.replace("VERSION", version);
    }
}

