/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.VersionText;
import org.eclipse.jetty.toolchain.version.git.GitCommand;

public class GenVersionTextMojo
extends AbstractMojo {
    private File basedir;
    protected Settings settings;
    private String version;
    private boolean sortExisting = false;
    private File versionTextInputFile;
    private File versionTextOuputFile;
    private String classifier = "version";
    private String type = "txt";
    private MavenProjectHelper projectHelper;
    private MavenProject project;

    private void ensureDirectoryExists(File dir) throws MojoFailureException {
        if (dir.exists() && dir.isDirectory()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new MojoFailureException("Unable to create directory: " + dir.getAbsolutePath());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.hasVersionTextFile()) {
            return;
        }
        try {
            VersionText versionText = new VersionText();
            versionText.read(this.versionTextInputFile);
            versionText.setSortExisting(this.sortExisting);
            String currentVersion = versionText.toFullVersion(this.version);
            Release rel = versionText.findRelease(currentVersion);
            if (rel == null) {
                rel = new Release(currentVersion);
            }
            this.getLog().info((CharSequence)("Updating version section: " + this.version));
            String priorVersion = versionText.getPriorVersion(currentVersion);
            if (priorVersion == null) {
                priorVersion = versionText.getReleases().get(0).getVersion();
            }
            this.getLog().debug((CharSequence)("Prior version in VERSION.txt is " + priorVersion));
            GitCommand git = new GitCommand();
            git.setWorkDir(this.basedir);
            git.setLog(this.getLog());
            String priorTagId = git.findTagMatching(priorVersion);
            this.getLog().debug((CharSequence)("Tag for prior version [" + priorVersion + "] is " + priorTagId));
            if (priorTagId == null) {
                throw new MojoFailureException("Unable to find git tag id for version id [" + priorVersion + "]");
            }
            String priorCommitId = git.getTagCommitId(priorTagId);
            this.getLog().debug((CharSequence)("Commit ID from [" + priorTagId + "]: " + priorCommitId));
            String currentTagId = git.findTagMatching(currentVersion);
            String currentCommitId = "HEAD";
            if (currentTagId != null) {
                currentCommitId = git.getTagCommitId(currentTagId);
            }
            this.getLog().debug((CharSequence)("Commit ID to [" + currentVersion + "]: " + currentCommitId));
            git.populateIssuesForRange(priorCommitId, currentCommitId, rel);
            if (rel.getReleasedOn() == null) {
                rel.setReleasedOn(new Date());
            }
            versionText.replaceOrPrepend(rel);
            this.ensureDirectoryExists(this.versionTextOuputFile.getCanonicalFile().getParentFile());
            versionText.write(this.versionTextOuputFile);
            this.getLog().debug((CharSequence)("New VERSION.txt written at " + this.versionTextOuputFile.getAbsolutePath()));
            this.getLog().debug((CharSequence)("Classifier = " + this.classifier));
            this.getLog().debug((CharSequence)("Type = " + this.type));
            this.projectHelper.attachArtifact(this.project, this.type, this.classifier, this.versionTextOuputFile);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to generate replacement VERSION.txt", (Throwable)e);
        }
    }

    private boolean hasVersionTextFile() {
        if (this.versionTextInputFile == null) {
            this.getLog().info((CharSequence)"Skipping :version-text-gen - the <versionTextInputFile> was not specified.");
            return false;
        }
        if (!this.versionTextInputFile.exists()) {
            this.getLog().info((CharSequence)("Skipping :version-text-gen - file not found: " + this.versionTextInputFile.getAbsolutePath()));
            return false;
        }
        return true;
    }
}

