/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.junit.Assert;

public final class PathAssert {
    private PathAssert() {
    }

    public static void assertDirExists(String msg, File path) {
        PathAssert.assertPathExists(msg, path);
        Assert.assertTrue((String)(msg + " path should be a Dir : " + path.getAbsolutePath()), (boolean)path.isDirectory());
    }

    public static void assertDirExists(String msg, Path path) {
        PathAssert.assertPathExists(msg, path);
        Assert.assertTrue((String)(msg + " path should be a Dir : " + path), (boolean)Files.isDirectory(path, new LinkOption[0]));
    }

    public static void assertFileExists(String msg, File path) {
        PathAssert.assertPathExists(msg, path);
        Assert.assertTrue((String)(msg + " path should be a File : " + path.getAbsolutePath()), (boolean)path.isFile());
    }

    public static void assertFileExists(String msg, Path path) {
        PathAssert.assertPathExists(msg, path);
        Assert.assertTrue((String)(msg + " path should be a File : " + path), (boolean)Files.isRegularFile(path, new LinkOption[0]));
    }

    public static void assertPathExists(String msg, File path) {
        Assert.assertTrue((String)(msg + " path should exist: " + path.getAbsolutePath()), (boolean)path.exists());
    }

    public static void assertPathExists(String msg, Path path) {
        Assert.assertTrue((String)(msg + " path should exist: " + path), (boolean)Files.exists(path, new LinkOption[0]));
    }

    public static void assertNotPathExists(String msg, File path) {
        Assert.assertFalse((String)(msg + " path should not exist: " + path.getAbsolutePath()), (boolean)path.exists());
    }

    public static void assertNotPathExists(String msg, Path path) {
        Assert.assertFalse((String)(msg + " path should not exist: " + path), (boolean)Files.exists(path, new LinkOption[0]));
    }
}

