/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQueue<E>
extends LinkedBlockingQueue<E> {
    public static final boolean DEBUG = false;
    private static final long DEBUG_START = System.currentTimeMillis();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition countReached = this.lock.newCondition();
    private int goalCount = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E o) {
        this.debug("add(%s)", o);
        this.lock.lock();
        try {
            boolean ret = super.add(o);
            this.debug("added: %s", o);
            this.goalCheck();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitEventCount(int expectedEventCount, int timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
        this.debug("awaitEventCount(%d,%d,%s)", new Object[]{expectedEventCount, timeoutDuration, timeoutUnit});
        this.lock.lock();
        try {
            this.goalCount = expectedEventCount;
            if (this.goalCheck()) {
                return;
            }
            this.debug("awaiting countReached", new Object[0]);
            if (!this.countReached.await(timeoutDuration, timeoutUnit)) {
                throw new TimeoutException(String.format("Timeout waiting for %d events (found %d)", expectedEventCount, this.size()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void debug(String format, Object ... args) {
    }

    private boolean goalCheck() {
        if (this.size() >= this.goalCount) {
            this.countReached.signalAll();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o) {
        this.debug("offer(%s)", o);
        this.lock.lock();
        try {
            boolean ret = super.offer(o);
            this.debug("offered: %s", o);
            this.goalCheck();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
    }
}

