/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Properties;
import org.eclipse.jetty.toolchain.test.IO;

public class SimpleRequest {
    private URI baseUri;

    public SimpleRequest(URI serverURI) throws UnknownHostException {
        this.baseUri = serverURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String relativePath) throws IOException {
        String string;
        URI uri = this.baseUri.resolve(relativePath);
        System.out.println("GET (String): " + uri.toASCIIString());
        InputStream in = null;
        InputStreamReader reader = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.connect();
            if (200 != connection.getResponseCode()) {
                String body = this.getPotentialBody(connection);
                String err = String.format("GET request failed (%d %s) %s%n%s", connection.getResponseCode(), connection.getResponseMessage(), uri.toASCIIString(), body);
                throw new IOException(err);
            }
            in = connection.getInputStream();
            reader = new InputStreamReader(in);
            StringWriter writer = new StringWriter();
            IO.copy(reader, writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            IO.close(reader);
            IO.close(in);
            throw throwable;
        }
        IO.close(reader);
        IO.close(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String relativePath) throws IOException {
        Properties properties;
        URI uri = this.baseUri.resolve(relativePath);
        System.out.println("GET (Properties): " + uri.toASCIIString());
        InputStream in = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.connect();
            if (200 != connection.getResponseCode()) {
                String body = this.getPotentialBody(connection);
                String err = String.format("GET request failed (%d %s) %s%n%s", connection.getResponseCode(), connection.getResponseMessage(), uri.toASCIIString(), body);
                throw new IOException(err);
            }
            in = connection.getInputStream();
            Properties props = new Properties();
            props.load(in);
            properties = props;
        }
        catch (Throwable throwable) {
            IO.close(in);
            throw throwable;
        }
        IO.close(in);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPotentialBody(HttpURLConnection connection) {
        String string;
        InputStream in = null;
        InputStreamReader reader = null;
        try {
            in = connection.getInputStream();
            reader = new InputStreamReader(in);
            StringWriter writer = new StringWriter();
            IO.copy(reader, writer);
            string = writer.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = "<no body:" + e.getMessage() + ">";
            }
            catch (Throwable throwable) {
                IO.close(reader);
                IO.close(in);
                throw throwable;
            }
            IO.close(reader);
            IO.close(in);
            return string2;
        }
        IO.close(reader);
        IO.close(in);
        return string;
    }
}

