/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import org.eclipse.jetty.toolchain.test.annotation.Slow;
import org.eclipse.jetty.toolchain.test.annotation.Stress;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedRunner
extends BlockJUnit4ClassRunner {
    private boolean slowTestsEnabled = false;
    private boolean stressTestsEnabled = false;

    public AdvancedRunner(Class<?> klass) throws InitializationError {
        super(klass);
        boolean isFast = System.getProperty("test.fast") != null;
        this.slowTestsEnabled = this.isEnabled("test.slow", !isFast);
        this.stressTestsEnabled = this.isEnabled("test.stress", false);
    }

    private boolean isEnabled(String key, boolean def) {
        String val = System.getProperty(key);
        if (val == null) {
            return def;
        }
        if (val.length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(val);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        EachTestNotifier eachNotifier = this.makeNotifier(method, notifier);
        if (!this.slowTestsEnabled && method.getAnnotation(Slow.class) != null) {
            eachNotifier.fireTestIgnored();
            return;
        }
        if (!this.stressTestsEnabled && method.getAnnotation(Stress.class) != null) {
            eachNotifier.fireTestIgnored();
            return;
        }
        super.runChild(method, notifier);
    }

    private EachTestNotifier makeNotifier(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        return new EachTestNotifier(notifier, description);
    }
}

