/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;

public final class OS {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean IS_WINDOWS = OS.isOSName("Windows");
    public static final boolean IS_OSX = OS.isOSName("Mac OS X");
    public static final boolean IS_LINUX = OS.isOSName("Linux") || OS.isOSName("LINUX");
    public static final boolean IS_UNIX = OS.isOSName("Unix") || OS.isOSName("AIX") || IS_LINUX || IS_OSX;
    public static final String LN = System.getProperty("line.separator");

    public static String separators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private static boolean isOSName(String name) {
        if (OS_NAME == null || name == null) {
            return false;
        }
        return OS_NAME.contains(name);
    }
}

