/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.perf;

import java.util.concurrent.TimeUnit;

public class PlatformTimer {
    private final long nativeResolution;
    private final long emulatedResolution;

    private PlatformTimer(long nativeResolution, long emulatedResolution) {
        this.nativeResolution = nativeResolution;
        this.emulatedResolution = emulatedResolution;
    }

    public long getNativeResolution() {
        return this.nativeResolution;
    }

    public long getEmulatedResolution() {
        return this.emulatedResolution;
    }

    public void sleep(long micros) {
        if (micros > this.nativeResolution) {
            PlatformTimer.sleepNative(micros);
        } else {
            PlatformTimer.sleepEmulated(micros);
        }
    }

    public String toString() {
        return String.format("%s[native=%d,emulated=%d]", this.getClass().getName(), this.getNativeResolution(), this.getEmulatedResolution());
    }

    public static PlatformTimer detect() {
        PlatformTimer.detectNative();
        long nativeAccuracy = PlatformTimer.detectNative();
        PlatformTimer.detectEmulated();
        long emulatedAccuracy = PlatformTimer.detectEmulated();
        while (emulatedAccuracy > nativeAccuracy) {
            emulatedAccuracy = PlatformTimer.detectEmulated();
        }
        return new PlatformTimer(nativeAccuracy, emulatedAccuracy);
    }

    private static long detectNative() {
        return PlatformTimer.detect(true);
    }

    private static long detectEmulated() {
        return PlatformTimer.detect(false);
    }

    private static long detect(boolean useNative) {
        long max;
        System.gc();
        long min = 0L;
        long value = max = 100000L;
        while (max > min + 1L) {
            long begin = System.nanoTime();
            if (useNative) {
                PlatformTimer.sleepNative(value);
            } else {
                PlatformTimer.sleepEmulated(value);
            }
            long end = System.nanoTime();
            long elapsedMicros = TimeUnit.NANOSECONDS.toMicros(end - begin);
            if (elapsedMicros > value + value / 10L) {
                min = value;
            } else {
                max = value;
            }
            value = (min + max) / 2L;
        }
        return value;
    }

    private static void sleepNative(long micros) {
        try {
            TimeUnit.MICROSECONDS.sleep(micros);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(x);
        }
    }

    private static void sleepEmulated(long micros) {
        long end = System.nanoTime() + TimeUnit.MICROSECONDS.toNanos(micros);
        while (System.nanoTime() < end) {
            Thread.yield();
        }
    }
}

