/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.perf;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PlatformMonitor
implements Runnable {
    private final java.lang.management.OperatingSystemMXBean operatingSystem;
    private final CompilationMXBean jitCompiler;
    private final MemoryMXBean heapMemory;
    private final AtomicInteger starts = new AtomicInteger();
    private final MemoryPoolMXBean edenMemoryPool;
    private final MemoryPoolMXBean survivorMemoryPool;
    private final MemoryPoolMXBean tenuredMemoryPool;
    private final boolean hasMemoryPools;
    private final GarbageCollectorMXBean youngCollector;
    private final GarbageCollectorMXBean oldCollector;
    private final boolean hasCollectors;
    private ScheduledFuture<?> memoryPoller;
    private ScheduledExecutorService scheduler;
    private long memoryPollInterval = 250L;
    private long youngCount;
    private long youngTime;
    private long oldCount;
    private long oldTime;
    private long lastEden;
    private long lastSurvivor;
    private long lastTenured;
    private long time;
    private long cpuTime;
    private long jitTime;
    private Stop stop;

    public PlatformMonitor() {
        this.operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        this.jitCompiler = ManagementFactory.getCompilationMXBean();
        this.heapMemory = ManagementFactory.getMemoryMXBean();
        List<MemoryPoolMXBean> memoryPools = ManagementFactory.getMemoryPoolMXBeans();
        MemoryPoolMXBean emp = null;
        MemoryPoolMXBean smp = null;
        MemoryPoolMXBean omp = null;
        for (MemoryPoolMXBean memoryPool : memoryPools) {
            if ("PS Eden Space".equals(memoryPool.getName()) || "Par Eden Space".equals(memoryPool.getName()) || "G1 Eden".equals(memoryPool.getName())) {
                emp = memoryPool;
                continue;
            }
            if ("PS Survivor Space".equals(memoryPool.getName()) || "Par Survivor Space".equals(memoryPool.getName()) || "G1 Survivor".equals(memoryPool.getName())) {
                smp = memoryPool;
                continue;
            }
            if (!"PS Old Gen".equals(memoryPool.getName()) && !"CMS Old Gen".equals(memoryPool.getName()) && !"G1 Old Gen".equals(memoryPool.getName())) continue;
            omp = memoryPool;
        }
        this.edenMemoryPool = emp;
        this.survivorMemoryPool = smp;
        this.tenuredMemoryPool = omp;
        this.hasMemoryPools = emp != null && smp != null && omp != null;
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        GarbageCollectorMXBean yc = null;
        GarbageCollectorMXBean oc = null;
        for (GarbageCollectorMXBean garbageCollector : garbageCollectors) {
            if ("PS Scavenge".equals(garbageCollector.getName()) || "ParNew".equals(garbageCollector.getName()) || "G1 Young Generation".equals(garbageCollector.getName())) {
                yc = garbageCollector;
                continue;
            }
            if (!"PS MarkSweep".equals(garbageCollector.getName()) && !"ConcurrentMarkSweep".equals(garbageCollector.getName()) && !"G1 Old Generation".equals(garbageCollector.getName())) continue;
            oc = garbageCollector;
        }
        this.youngCollector = yc;
        this.oldCollector = oc;
        this.hasCollectors = yc != null && oc != null;
    }

    public long getMemoryPollInterval() {
        return this.memoryPollInterval;
    }

    public void setMemoryPollInterval(long gcPollInterval) {
        this.memoryPollInterval = gcPollInterval;
    }

    @Override
    public void run() {
        long eden = this.edenMemoryPool.getUsage().getUsed();
        long survivor = this.survivorMemoryPool.getUsage().getUsed();
        long tenured = this.tenuredMemoryPool.getUsage().getUsed();
        if (this.lastEden < eden) {
            this.stop.edenBytes += eden - this.lastEden;
        }
        if (this.lastSurvivor < survivor) {
            this.stop.survivorBytes += survivor - this.lastSurvivor;
        }
        if (this.lastTenured <= tenured) {
            this.stop.tenuredBytes += tenured - this.lastTenured;
        }
        this.lastEden = eden;
        this.lastSurvivor = survivor;
        this.lastTenured = tenured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Start start() {
        PlatformMonitor platformMonitor = this;
        synchronized (platformMonitor) {
            OperatingSystemMXBean os;
            if (this.starts.incrementAndGet() > 1) {
                return null;
            }
            Start start = new Start();
            this.stop = new Stop();
            System.gc();
            this.time = System.nanoTime();
            if (this.hasMemoryPools) {
                this.lastEden = this.edenMemoryPool.getUsage().getUsed();
                this.lastSurvivor = this.survivorMemoryPool.getUsage().getUsed();
                this.lastTenured = this.tenuredMemoryPool.getUsage().getUsed();
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
                this.memoryPoller = this.scheduler.scheduleWithFixedDelay(this, this.memoryPollInterval, this.memoryPollInterval, TimeUnit.MILLISECONDS);
            }
            if (this.hasCollectors) {
                this.youngCount = this.youngCollector.getCollectionCount();
                this.youngTime = this.youngCollector.getCollectionTime();
                this.oldCount = this.oldCollector.getCollectionCount();
                this.oldTime = this.oldCollector.getCollectionTime();
            }
            if (this.operatingSystem instanceof OperatingSystemMXBean) {
                os = (OperatingSystemMXBean)this.operatingSystem;
                this.cpuTime = os.getProcessCpuTime();
            }
            this.jitTime = this.jitCompiler.getTotalCompilationTime();
            start.date = System.currentTimeMillis();
            start.os = String.format("%s %s %s", this.operatingSystem.getName(), this.operatingSystem.getVersion(), this.operatingSystem.getArch());
            start.cores = this.stop.cores = this.operatingSystem.getAvailableProcessors();
            start.jvm = String.format("%s %s %s %s", System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.runtime.version"));
            if (this.operatingSystem instanceof OperatingSystemMXBean) {
                os = (OperatingSystemMXBean)this.operatingSystem;
                start.totalMemory = os.getTotalPhysicalMemorySize();
                start.freeMemory = os.getFreePhysicalMemorySize();
            }
            start.heap = this.heapMemory.getHeapMemoryUsage();
            start.eden = this.edenMemoryPool.getUsage();
            start.survivor = this.survivorMemoryPool.getUsage();
            start.tenured = this.tenuredMemoryPool.getUsage();
            return start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stop stop() {
        PlatformMonitor platformMonitor = this;
        synchronized (platformMonitor) {
            if (this.starts.decrementAndGet() > 0) {
                return null;
            }
            this.stop.date = System.currentTimeMillis();
            this.stop.time = System.nanoTime() - this.time;
            this.stop.jitTime = this.jitCompiler.getTotalCompilationTime() - this.jitTime;
            if (this.hasMemoryPools) {
                this.memoryPoller.cancel(false);
                this.scheduler.shutdown();
            } else {
                this.stop.tenuredBytes = -1L;
                this.stop.survivorBytes = -1L;
                this.stop.edenBytes = -1L;
            }
            if (this.hasCollectors) {
                this.stop.youngTime = this.youngCollector.getCollectionTime() - this.youngTime;
                this.stop.oldTime = this.oldCollector.getCollectionTime() - this.oldTime;
                this.stop.youngCount = this.youngCollector.getCollectionCount() - this.youngCount;
                this.stop.oldCount = this.oldCollector.getCollectionCount() - this.oldCount;
            } else {
                this.stop.oldTime = -1L;
                this.stop.youngTime = -1L;
                this.stop.oldCount = -1L;
                this.stop.youngCount = -1L;
            }
            if (this.operatingSystem instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean os = (OperatingSystemMXBean)this.operatingSystem;
                this.stop.cpuTime = os.getProcessCpuTime() - this.cpuTime;
            } else {
                this.stop.cpuTime = -1L;
            }
            return this.stop;
        }
    }

    public static class Stop
    extends Base {
        private int cores;
        public long date;
        public long time;
        public long jitTime;
        public long youngTime;
        public long youngCount;
        public long oldTime;
        public long oldCount;
        public long edenBytes;
        public long survivorBytes;
        public long tenuredBytes;
        public long cpuTime;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("- - - - - - - - - - - - - - - - - - - - ").append(this.EOL);
            builder.append("Monitoring Ended at ").append(new Date(this.date)).append(this.EOL);
            builder.append("Elapsed Time: ").append(TimeUnit.NANOSECONDS.toMillis(this.time)).append(" ms").append(this.EOL);
            builder.append("\tTime in JIT Compilation: ").append(this.jitTime).append(" ms").append(this.EOL);
            builder.append("\tTime in Young GC: ").append(this.youngTime).append(" ms (").append(this.youngCount).append(" collections)").append(this.EOL);
            builder.append("\tTime in Old GC: ").append(this.oldTime).append(" ms (").append(this.oldCount).append(" collections)").append(this.EOL);
            builder.append("Garbage Generated in Eden Space: ").append(this.mebiBytes(this.edenBytes)).append(" MiB").append(this.EOL);
            builder.append("Garbage Generated in Survivor Space: ").append(this.mebiBytes(this.survivorBytes)).append(" MiB").append(this.EOL);
            builder.append("Garbage Generated in Tenured Space: ").append(this.mebiBytes(this.tenuredBytes)).append(" MiB").append(this.EOL);
            builder.append("Average CPU Load: ").append(this.percent(this.cpuTime, this.time)).append("/").append(100 * this.cores).append(this.EOL);
            builder.append("========================================").append(this.EOL);
            return builder.toString();
        }
    }

    public static class Start
    extends Base {
        public long date;
        public String os;
        public int cores;
        public String jvm;
        public long totalMemory;
        public long freeMemory;
        public MemoryUsage heap;
        public MemoryUsage eden;
        public MemoryUsage survivor;
        public MemoryUsage tenured;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.EOL);
            builder.append("========================================").append(this.EOL);
            builder.append("Monitoring Started at ").append(new Date(this.date)).append(this.EOL);
            builder.append("Operative System: ").append(this.os).append(this.EOL);
            builder.append("JVM: ").append(this.jvm).append(this.EOL);
            builder.append("Processors: ").append(this.cores).append(this.EOL);
            builder.append("System Memory: ").append(this.percent(this.totalMemory - this.freeMemory, this.totalMemory)).append("% used of ").append(this.gibiBytes(this.totalMemory)).append(" GiB").append(this.EOL);
            builder.append("Used Heap Size: ").append(this.mebiBytes(this.heap.getUsed())).append(" MiB").append(this.EOL);
            builder.append("Max Heap Size: ").append(this.mebiBytes(this.heap.getMax())).append(" MiB").append(this.EOL);
            builder.append("Young Generation Heap Size: ").append(this.mebiBytes(this.heap.getMax() - this.tenured.getMax())).append(" MiB").append(this.EOL);
            builder.append("- - - - - - - - - - - - - - - - - - - - ").append(this.EOL);
            return builder.toString();
        }
    }

    private static class Base {
        public String EOL = System.lineSeparator();

        private Base() {
        }

        public float percent(long dividend, long divisor) {
            if (divisor != 0L) {
                return (float)dividend * 100.0f / (float)divisor;
            }
            return Float.NaN;
        }

        public float mebiBytes(long bytes) {
            return (float)bytes / 1024.0f / 1024.0f;
        }

        public float gibiBytes(long bytes) {
            return (float)bytes / 1024.0f / 1024.0f / 1024.0f;
        }
    }
}

