/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.perf;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class MeasureRecorder {
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong min = new AtomicLong();
    private final AtomicLong max = new AtomicLong();
    private final AtomicLong total = new AtomicLong();
    private final ConcurrentMap<Long, AtomicLong> measures = new ConcurrentHashMap<Long, AtomicLong>();
    private final Converter converter;
    private final String name;
    private final String unit;

    public MeasureRecorder(Converter converter, String name, String unit) {
        this.converter = converter;
        this.name = name;
        this.unit = unit;
    }

    public void reset() {
        this.count.set(0L);
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
        this.total.set(0L);
        this.measures.clear();
    }

    public void record(long measure, boolean distribution) {
        this.count.incrementAndGet();
        MeasureRecorder.updateMin(this.min, measure);
        MeasureRecorder.updateMax(this.max, measure);
        this.total.addAndGet(measure);
        if (distribution) {
            AtomicLong count = (AtomicLong)this.measures.get(measure);
            if (count == null) {
                count = new AtomicLong();
                AtomicLong existing = this.measures.putIfAbsent(measure, count);
                if (existing != null) {
                    count = existing;
                }
            }
            count.incrementAndGet();
        }
    }

    public Snapshot snapshot() {
        TreeMap copy = new TreeMap();
        for (Map.Entry entry : this.measures.entrySet()) {
            copy.put(entry.getKey(), ((AtomicLong)entry.getValue()).get());
        }
        return new Snapshot(this.count.get(), this.min.get(), this.max.get(), this.total.get(), copy);
    }

    public static void updateMin(AtomicLong currentMin, long newValue) {
        long oldValue = currentMin.get();
        while (newValue < oldValue && !currentMin.compareAndSet(oldValue, newValue)) {
            oldValue = currentMin.get();
        }
    }

    public static void updateMax(AtomicLong currentMax, long newValue) {
        long oldValue = currentMax.get();
        while (newValue > oldValue && !currentMax.compareAndSet(oldValue, newValue)) {
            oldValue = currentMax.get();
        }
    }

    public static interface Converter {
        public long convert(long var1);
    }

    public class Snapshot {
        public final long count;
        public final long min;
        public final long max;
        public final long total;
        public final Map<Long, Long> measures;

        private Snapshot(long count, long min, long max, long total, Map<Long, Long> measures) {
            this.count = count;
            this.min = min;
            this.max = max;
            this.total = total;
            this.measures = measures;
        }

        public String toString() {
            String eol = System.lineSeparator();
            StringBuilder builder = new StringBuilder();
            long measureAt50thPercentile = 0L;
            long measureAt99thPercentile = 0L;
            if (this.count == 1L) {
                measureAt50thPercentile = this.min;
                measureAt99thPercentile = this.max;
            } else if (this.count > 1L) {
                long samples = 0L;
                long maxLatencyBucketFrequency = 0L;
                long previousMeasure = 0L;
                long[] measureBucketFrequencies = new long[20];
                long minMeasure = this.min;
                long measureRange = this.max - minMeasure;
                Iterator<Map.Entry<Long, Long>> entries = this.measures.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<Long, Long> entry = entries.next();
                    long latency = entry.getKey();
                    Long bucketIndex = measureRange == 0L ? 0L : (latency - minMeasure) * (long)measureBucketFrequencies.length / measureRange;
                    int index = bucketIndex.intValue() == measureBucketFrequencies.length ? measureBucketFrequencies.length - 1 : bucketIndex.intValue();
                    long value = entry.getValue();
                    samples += value;
                    int n = index;
                    measureBucketFrequencies[n] = measureBucketFrequencies[n] + value;
                    if (measureBucketFrequencies[index] > maxLatencyBucketFrequency) {
                        maxLatencyBucketFrequency = measureBucketFrequencies[index];
                    }
                    if (measureAt50thPercentile == 0L && samples > this.count / 2L) {
                        measureAt50thPercentile = (previousMeasure + latency) / 2L;
                    }
                    if (measureAt99thPercentile == 0L && samples > this.count - this.count / 100L) {
                        measureAt99thPercentile = (previousMeasure + latency) / 2L;
                    }
                    previousMeasure = latency;
                    entries.remove();
                }
                builder.append(MeasureRecorder.this.name).append(" - distribution curve (x axis: frequency, y axis: ").append(MeasureRecorder.this.name).append("):").append(eol);
                double percentile = 0.0;
                for (int i = 0; i < measureBucketFrequencies.length; ++i) {
                    int j;
                    int value;
                    long latencyBucketFrequency = measureBucketFrequencies[i];
                    int n = value = maxLatencyBucketFrequency == 0L ? 0 : Math.round((float)latencyBucketFrequency * (float)measureBucketFrequencies.length / (float)maxLatencyBucketFrequency);
                    if (value == measureBucketFrequencies.length) {
                        --value;
                    }
                    for (j = 0; j < value; ++j) {
                        builder.append(" ");
                    }
                    builder.append("@");
                    for (j = value + 1; j < measureBucketFrequencies.length; ++j) {
                        builder.append(" ");
                    }
                    builder.append("  _  ");
                    double percentage = 100.0 * (double)latencyBucketFrequency / (double)samples;
                    builder.append(MeasureRecorder.this.converter.convert(measureRange * (long)(i + 1) / (long)measureBucketFrequencies.length + minMeasure));
                    builder.append(String.format(" %s (%d, %.2f%%)", MeasureRecorder.this.unit, latencyBucketFrequency, percentage));
                    double last = percentile;
                    percentile += percentage;
                    if (last < 50.0 && percentile >= 50.0) {
                        builder.append(" ^50%");
                    }
                    if (last < 85.0 && percentile >= 85.0) {
                        builder.append(" ^85%");
                    }
                    if (last < 95.0 && percentile >= 95.0) {
                        builder.append(" ^95%");
                    }
                    if (last < 99.0 && percentile >= 99.0) {
                        builder.append(" ^99%");
                    }
                    if (last < 99.9 && percentile >= 99.9) {
                        builder.append(" ^99.9%");
                    }
                    builder.append(eol);
                }
            }
            builder.append(String.format("%s - %d samples | 50th%%/99th%%/100th%% = %d/%d/%d %s%n", MeasureRecorder.this.name, this.count, MeasureRecorder.this.converter.convert(measureAt50thPercentile), MeasureRecorder.this.converter.convert(measureAt99thPercentile), MeasureRecorder.this.converter.convert(this.max), MeasureRecorder.this.unit));
            return builder.toString();
        }
    }
}

