/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.modifysources;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.modules.ModuleDeclaration;
import com.github.javaparser.ast.modules.ModuleExportsDirective;
import com.github.javaparser.ast.modules.ModuleOpensDirective;
import com.github.javaparser.ast.modules.ModuleProvidesDirective;
import com.github.javaparser.ast.modules.ModuleRequiresDirective;
import com.github.javaparser.ast.modules.ModuleUsesDirective;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.ModifierVisitor;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.utils.SourceRoot;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="modify-sources-ee9-to-ee8", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ModifyEE9ToEE8
extends AbstractMojo {
    @org.apache.maven.plugins.annotations.Parameter(property="sourceProjectLocation", required=true)
    private File sourceProjectLocation;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.build.directory}/generated-sources/ee8", property="outputLocation", required=true)
    private File outputDirectory;
    @org.apache.maven.plugins.annotations.Parameter(property="jetty.modifysources.EE9toEE8.skip")
    private boolean skip;
    @org.apache.maven.plugins.annotations.Parameter(property="jetty.modifysources.EE9toEE8.moveDirectoryStructure")
    private boolean moveDirectoryStructure = true;
    @org.apache.maven.plugins.annotations.Parameter(property="jetty.modifysources.testSources")
    private boolean testSources = true;
    @org.apache.maven.plugins.annotations.Parameter(property="jetty.modifysources.addToCompileSourceRoot")
    private boolean addToCompileSourceRoot = false;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @org.apache.maven.plugins.annotations.Parameter
    protected Set<String> notTranslateStartsWith = Set.of("https://jakarta.ee/xml/ns/", "http://jakarta.ee/xml/ns/");

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"EE9toEE8 skip");
            return;
        }
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"EE9toEE8 skip pom packaging");
            return;
        }
        if (!this.sourceProjectLocation.exists()) {
            this.getLog().info((CharSequence)"EE9toEE8 sourceProjectLocation not exists");
            return;
        }
        this.getLog().info((CharSequence)("Transforming sources from " + this.sourceProjectLocation + " to " + this.outputDirectory));
        ArrayList<CompilationUnit> compilationUnitsToRename = new ArrayList<CompilationUnit>();
        try {
            SourceRoot sourceRoot = new SourceRoot(this.sourceProjectLocation.toPath());
            sourceRoot.getParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
            List parseResults = sourceRoot.tryToParse("");
            Path out = this.outputDirectory.toPath();
            if (Files.exists(out, new LinkOption[0])) {
                Files.walk(out, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            Files.createDirectories(out, new FileAttribute[0]);
            for (ParseResult parseResult : parseResults) {
                CompilationUnit cu = (CompilationUnit)parseResult.getResult().get();
                cu.findAll(VariableDeclarator.class).forEach(vd -> {
                    String nameAsString;
                    if (vd.getType() instanceof ClassOrInterfaceType && (nameAsString = ((ClassOrInterfaceType)vd.getType()).getNameAsString()).contains("Jakarta")) {
                        ((ClassOrInterfaceType)vd.getType()).setName(nameAsString.replace("Jakarta", "Javax"));
                    }
                    if (StringUtils.equals((CharSequence)vd.getNameAsString(), (CharSequence)"SERVLET_MAJOR_VERSION")) {
                        vd.setInitializer((Expression)new IntegerLiteralExpr("4"));
                    }
                });
                cu.findAll(ConstructorDeclaration.class).forEach(cd -> {
                    String typeName = cd.getNameAsString();
                    if (typeName.contains("Jakarta")) {
                        cd.setName(typeName.replace("Jakarta", "Javax"));
                    }
                    cd.getParameters().forEach(parameter -> {
                        ClassOrInterfaceType cit;
                        String name;
                        if (parameter.getType() instanceof ClassOrInterfaceType && (name = (cit = (ClassOrInterfaceType)parameter.getType()).getNameAsString()).contains("Jakarta")) {
                            cit.setName(name.replace("Jakarta", "Javax"));
                        }
                    });
                });
                cu.findAll(FieldDeclaration.class).stream().filter(fd -> ((VariableDeclarator)fd.getVariables().get(0)).getType() instanceof ClassOrInterfaceType).map(fd -> (ClassOrInterfaceType)((VariableDeclarator)fd.getVariables().get(0)).getType()).filter(cif -> cif.getTypeArguments().isPresent()).forEach(cif -> ((NodeList)cif.getTypeArguments().get()).stream().filter(type -> type instanceof ClassOrInterfaceType).map(type -> (ClassOrInterfaceType)type).forEach(classOrInterfaceType -> {
                    String currentName = classOrInterfaceType.getNameAsString();
                    if (currentName.contains("Jakarta")) {
                        classOrInterfaceType.setName(currentName.replace("Jakarta", "Javax"));
                    }
                }));
                cu.findAll(FieldAccessExpr.class).stream().filter(FieldAccessExpr::isFieldAccessExpr).filter(fieldAccessExpr -> fieldAccessExpr.getNameAsString().equals("ee9")).forEach(fieldAccessExpr -> fieldAccessExpr.setName("ee8"));
                cu.findAll(NameExpr.class).stream().filter(nameExpr -> nameExpr.getNameAsString().contains("Jakarta")).forEach(nameExpr -> {
                    String className = nameExpr.getNameAsString();
                    nameExpr.setName(className.replace("Jakarta", "Javax"));
                });
                cu.accept((GenericVisitor)new ModifierVisitor<Void>(){

                    public Node visit(ImportDeclaration n, Void arg) {
                        ModifyEE9ToEE8.changeEE9NameToEE8((NodeWithName)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(PackageDeclaration n, Void arg) {
                        ModifyEE9ToEE8.changeEE9NameToEE8((NodeWithName)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(Parameter n, Void arg) {
                        ModifyEE9ToEE8.changeEE9TypeToEE8((NodeWithType)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(VariableDeclarationExpr n, Void arg) {
                        NodeList variables = n.getVariables();
                        for (VariableDeclarator variable : variables) {
                            ModifyEE9ToEE8.changeEE9TypeToEE8((NodeWithType)variable);
                        }
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(MethodCallExpr n, Void arg) {
                        Expression expression;
                        String fullString = n.toString();
                        if (StringUtils.startsWith((CharSequence)fullString, (CharSequence)"org.eclipse.jetty.ee9.") && n.getScope().isPresent() && (expression = (Expression)n.getScope().get()).isFieldAccessExpr()) {
                            FieldAccessExpr fieldAccessExpr = expression.asFieldAccessExpr();
                            String classSimpleName = fieldAccessExpr.getName().asString();
                            String ee9PackageName = StringUtils.substringBefore((String)fullString, (String)("." + classSimpleName));
                            String ee8PackageName = StringUtils.replace((String)ee9PackageName, (String)"org.eclipse.jetty.ee9", (String)"org.eclipse.jetty.ee8");
                            NameExpr nameExpr = new NameExpr(ee8PackageName + "." + classSimpleName);
                            n.setScope((Expression)nameExpr);
                        }
                        if (StringUtils.startsWith((CharSequence)(fullString = n.toString()), (CharSequence)"EE9") && n.getScope().isPresent() && (expression = (Expression)n.getScope().get()).isNameExpr()) {
                            NameExpr nameExpr = ((Expression)n.getScope().get()).asNameExpr();
                            String oldExp = nameExpr.getNameAsString();
                            n.setScope((Expression)new NameExpr(oldExp.replaceFirst("EE9", "EE8")));
                        }
                        this.replaceMethodCallExpr(n, "Jakarta", "Javax");
                        this.replaceMethodCallExpr(n, "EE9", "EE8");
                        this.replaceMethodCallExpr(n, "org.eclipse.jetty.ee9", "org.eclipse.jetty.ee8");
                        return super.visit(n, (Object)arg);
                    }

                    private void replaceMethodCallExpr(MethodCallExpr n, String contains, String replace) {
                        String fullString = n.toString();
                        if (StringUtils.contains((CharSequence)fullString, (CharSequence)contains) && n.getScope().isPresent()) {
                            n.getArguments().stream().filter(node -> node instanceof NodeWithSimpleName).map(node -> (NodeWithSimpleName)node).filter(nameExpr -> nameExpr.getNameAsString().contains(contains)).forEach(nameExpr -> {
                                String className = nameExpr.getNameAsString();
                                nameExpr.setName(className.replace(contains, replace));
                            });
                            n.getChildNodes().stream().filter(node -> node instanceof FieldAccessExpr).map(node -> (FieldAccessExpr)node).filter(fieldAccessExpr -> fieldAccessExpr.getScope().isNameExpr()).map(nameExpr -> (NameExpr)nameExpr.getScope()).forEach(nameExpr -> {
                                String fullClassName = nameExpr.getNameAsString();
                                if (fullClassName.contains(contains)) {
                                    nameExpr.setName(fullClassName.replace(contains, replace));
                                }
                            });
                            n.getChildNodes().stream().filter(node -> node instanceof FieldAccessExpr).map(node -> (FieldAccessExpr)node).forEach(fieldAccessExpr -> {
                                String fullClassName = fieldAccessExpr.getNameAsString();
                                if (fullClassName.contains(contains)) {
                                    fieldAccessExpr.setName(fullClassName.replace(contains, replace));
                                }
                            });
                            n.getChildNodes().stream().filter(node -> node instanceof NameExpr).map(node -> (NameExpr)node).filter(nameExpr -> nameExpr.getNameAsString().contains(contains)).forEach(nameExpr -> {
                                String className = nameExpr.getNameAsString();
                                nameExpr.setName(className.replace(contains, replace));
                            });
                            n.getChildNodes().stream().filter(node -> node instanceof ClassExpr).map(node -> (ClassExpr)node).filter(classExpr -> classExpr.getTypeAsString().contains(contains)).forEach(classExpr -> {
                                String className = classExpr.getTypeAsString();
                                classExpr.setType(className.replace(contains, replace));
                            });
                        }
                    }

                    public Visitable visit(ClassExpr n, Void arg) {
                        ModifyEE9ToEE8.changeEE9TypeToEE8((NodeWithType)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(ClassOrInterfaceDeclaration n, Void arg) {
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(ClassOrInterfaceType n, Void arg) {
                        String newName;
                        ParseResult parseResult;
                        String currentName = n.toString();
                        JavaParser javaParser = new JavaParser();
                        if (currentName.startsWith("org.eclipse.jetty.ee9.") && (parseResult = javaParser.parseClassOrInterfaceType(newName = StringUtils.replace((String)currentName, (String)"org.eclipse.jetty.ee9.", (String)"org.eclipse.jetty.ee8."))).isSuccessful() && parseResult.getResult().isPresent()) {
                            n = (ClassOrInterfaceType)parseResult.getResult().get();
                        }
                        if (currentName.contains("jakarta") && (parseResult = javaParser.parseClassOrInterfaceType(newName = StringUtils.replace((String)currentName, (String)"jakarta", (String)"javax"))).isSuccessful() && parseResult.getResult().isPresent()) {
                            n = (ClassOrInterfaceType)parseResult.getResult().get();
                        }
                        if (currentName.contains("Jakarta") && (parseResult = javaParser.parseClassOrInterfaceType(newName = StringUtils.replace((String)currentName, (String)"Jakarta", (String)"Javax"))).isSuccessful() && parseResult.getResult().isPresent()) {
                            n = (ClassOrInterfaceType)parseResult.getResult().get();
                        }
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(StringLiteralExpr n, Void arg) {
                        if (ModifyEE9ToEE8.startsWith(n.getValue(), ModifyEE9ToEE8.this.notTranslateStartsWith)) {
                            return super.visit(n, (Object)arg);
                        }
                        if (StringUtils.contains((CharSequence)n.getValue(), (CharSequence)"jakarta")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"jakarta", (String)"javax"));
                        }
                        if (StringUtils.contains((CharSequence)n.getValue(), (CharSequence)"Jakarta")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"Jakarta", (String)"Javax"));
                        }
                        if (StringUtils.contains((CharSequence)n.getValue(), (CharSequence)"jetty-ee9")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"jetty-ee9", (String)"jetty-ee8"));
                        }
                        if (StringUtils.equals((CharSequence)n.getValue(), (CharSequence)"ee9")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"ee9", (String)"ee8"));
                        }
                        if (StringUtils.contains((CharSequence)n.getValue(), (CharSequence)"ee9")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"ee9", (String)"ee8"));
                        }
                        if (StringUtils.contains((CharSequence)n.getValue(), (CharSequence)"EE9")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"EE9", (String)"EE8"));
                        }
                        if (StringUtils.contains((CharSequence)n.getValue(), (CharSequence)"org.eclipse.jetty.ee9")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"org.eclipse.jetty.ee9", (String)"org.eclipse.jetty.ee8"));
                        }
                        if (StringUtils.contains((CharSequence)n.getValue(), (CharSequence)"org/eclipse/jetty/ee9")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"org/eclipse/jetty/ee9", (String)"org/eclipse/jetty/ee8"));
                        }
                        if (StringUtils.contains((CharSequence)n.getValue(), (CharSequence)"webdefault-ee9.xml")) {
                            n.setString(StringUtils.replace((String)n.getValue(), (String)"webdefault-ee9.xml", (String)"webdefault-ee8.xml"));
                        }
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(CastExpr n, Void arg) {
                        ModifyEE9ToEE8.changeEE9TypeToEE8((NodeWithType)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(ModuleDeclaration n, Void arg) {
                        ModifyEE9ToEE8.changeEE9NameToEE8((NodeWithName)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(ModuleExportsDirective n, Void arg) {
                        ModifyEE9ToEE8.changeEE9NameToEE8((NodeWithName)n);
                        if (!n.getModuleNames().isEmpty()) {
                            n.getModuleNames().stream().filter(name -> name.getQualifier().isPresent()).filter(name -> StringUtils.contains((CharSequence)((Name)name.getQualifier().get()).asString(), (CharSequence)"org.eclipse.jetty.ee9.")).forEach(name -> name.setQualifier(new Name(StringUtils.replace((String)((Name)name.getQualifier().get()).asString(), (String)"org.eclipse.jetty.ee9.", (String)"org.eclipse.jetty.ee8."))));
                            n.getModuleNames().stream().filter(name -> name.getQualifier().isPresent()).filter(name -> StringUtils.contains((CharSequence)((Name)name.getQualifier().get()).asString(), (CharSequence)".jakarta")).forEach(name -> name.setQualifier(new Name(StringUtils.replace((String)((Name)name.getQualifier().get()).asString(), (String)".jakarta", (String)".javax"))));
                        }
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(ModuleRequiresDirective n, Void arg) {
                        String newName;
                        String currentName = n.getName().asString();
                        if (StringUtils.equals((CharSequence)"jakarta.mail", (CharSequence)currentName) && n.isStatic()) {
                            n.setName("javax.mail.glassfish");
                        }
                        if (StringUtils.contains((CharSequence)currentName, (CharSequence)"jakarta.transaction")) {
                            newName = StringUtils.replace((String)currentName, (String)"jakarta.transaction", (String)"java.transaction");
                            n.setName(newName);
                        }
                        if (StringUtils.contains((CharSequence)currentName, (CharSequence)"jakarta.annotation")) {
                            newName = StringUtils.replace((String)currentName, (String)"jakarta.annotation", (String)"java.annotation");
                            n.setName(newName);
                        }
                        ModifyEE9ToEE8.changeEE9NameToEE8((NodeWithName)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(ModuleProvidesDirective n, Void arg) {
                        ModifyEE9ToEE8.changeEE9NameToEE8((NodeWithName)n);
                        if (!n.getWith().isEmpty()) {
                            n.getWith().stream().filter(name -> name.getQualifier().isPresent()).filter(name -> StringUtils.contains((CharSequence)((Name)name.getQualifier().get()).asString(), (CharSequence)"org.eclipse.jetty.ee9.")).forEach(name -> name.setQualifier(new Name(StringUtils.replace((String)((Name)name.getQualifier().get()).asString(), (String)"org.eclipse.jetty.ee9.", (String)"org.eclipse.jetty.ee8."))));
                            n.getWith().stream().filter(name -> name.getQualifier().isPresent()).filter(name -> StringUtils.contains((CharSequence)((Name)name.getQualifier().get()).asString(), (CharSequence)".jakarta")).forEach(name -> name.setQualifier(new Name(StringUtils.replace((String)((Name)name.getQualifier().get()).asString(), (String)".jakarta", (String)".javax"))));
                            n.getWith().stream().filter(name -> StringUtils.contains((CharSequence)name.getIdentifier(), (CharSequence)"Jakarta")).forEach(name -> name.setIdentifier(StringUtils.replace((String)name.getIdentifier(), (String)"Jakarta", (String)"Javax")));
                        }
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(ModuleUsesDirective n, Void arg) {
                        ModifyEE9ToEE8.changeEE9NameToEE8((NodeWithName)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(ModuleOpensDirective n, Void arg) {
                        ModifyEE9ToEE8.changeEE9NameToEE8((NodeWithName)n);
                        return super.visit(n, (Object)arg);
                    }

                    public Visitable visit(JavadocComment n, Void arg) {
                        if (StringUtils.contains((CharSequence)n.getContent(), (CharSequence)"jakarta")) {
                            n.setContent(StringUtils.replace((String)n.getContent(), (String)"jakarta", (String)"javax"));
                        }
                        if (StringUtils.contains((CharSequence)n.getContent(), (CharSequence)"Jakarta")) {
                            n.setContent(StringUtils.replace((String)n.getContent(), (String)"Jakarta", (String)"Javax"));
                        }
                        if (StringUtils.contains((CharSequence)n.getContent(), (CharSequence)"ee9")) {
                            n.setContent(StringUtils.replace((String)n.getContent(), (String)"ee9", (String)"ee8"));
                        }
                        return super.visit(n, (Object)arg);
                    }
                }, null);
                if ((!cu.getPrimaryTypeName().isPresent() || !((String)cu.getPrimaryTypeName().get()).contains("Jakarta") && !((String)cu.getPrimaryTypeName().get()).contains("ee9")) && !((String)cu.getPrimaryTypeName().get()).contains("EE9")) continue;
                compilationUnitsToRename.add(cu);
            }
            sourceRoot.saveAll(out);
            File ee9Directory = new File(this.outputDirectory, "org/eclipse/jetty/ee9");
            if (this.moveDirectoryStructure && Files.isDirectory(ee9Directory.toPath(), new LinkOption[0])) {
                File ee8Directory = new File(this.outputDirectory, "org/eclipse/jetty/ee8");
                FileUtils.moveDirectory((File)ee9Directory, (File)ee8Directory);
                List<Path> pathsEndedJakarta = Files.walk(ee8Directory.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().endsWith("jakarta")).collect(Collectors.toList());
                pathsEndedJakarta.forEach(path -> {
                    try {
                        FileUtils.moveDirectory((File)path.toFile(), (File)new File(path.toFile().getParentFile(), "javax"));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            for (CompilationUnit cu : compilationUnitsToRename) {
                String previousPackage = ((PackageDeclaration)cu.getPackageDeclaration().get()).getName().toString();
                String previousFullClassName = previousPackage + "." + (String)cu.getPrimaryTypeName().get();
                String className = this.replaceClassName((String)cu.getPrimaryTypeName().get());
                String fullClassName = previousPackage + "." + className;
                ((TypeDeclaration)cu.getPrimaryType().get()).setName(className);
                Path newPath = out.resolve(fullClassName.replace('.', '/') + ".java");
                String newClassSource = cu.toString();
                Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                Files.createFile(newPath, new FileAttribute[0]);
                Files.write(newPath, newClassSource.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                Path oldPath = out.resolve(previousFullClassName.replace('.', '/') + ".java");
                Files.deleteIfExists(oldPath);
            }
            if (this.addToCompileSourceRoot) {
                if (this.testSources) {
                    this.project.getTestCompileSourceRoots().add(this.outputDirectory.getAbsolutePath());
                } else {
                    this.project.getCompileSourceRoots().add(this.outputDirectory.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("fail to modify jetty sources", (Exception)e);
        }
    }

    private String replaceClassName(String previousClassName) {
        String className = StringUtils.replace((String)previousClassName, (String)"Jakarta", (String)"Javax");
        className = StringUtils.replace((String)className, (String)"ee9", (String)"ee8");
        className = StringUtils.replace((String)className, (String)"EE9", (String)"EE8");
        return className;
    }

    private static void changeEE9NameToEE8(NodeWithName n) {
        String currentName = n.getName().asString();
        String newName = ModifyEE9ToEE8.changeEE9TypeToEE8(currentName);
        if (newName != null) {
            n.setName(newName);
        }
    }

    private static void changeEE9TypeToEE8(NodeWithType n) {
        String currentType = n.getTypeAsString();
        String newType = ModifyEE9ToEE8.changeEE9TypeToEE8(currentType);
        if (newType != null) {
            n.setType(newType);
        }
    }

    public static String changeEE9TypeToEE8(String currentType) {
        String newType;
        if ((currentType = currentType.replaceFirst("Jakarta", "Javax")).contains("jakarta") && !(currentType = (newType = StringUtils.replace((String)currentType, (String)"jakarta", (String)"javax"))).startsWith("org.eclipse.jetty.ee9")) {
            return currentType;
        }
        if (currentType.startsWith("org.eclipse.jetty.ee9")) {
            newType = StringUtils.replace((String)currentType, (String)"org.eclipse.jetty.ee9", (String)"org.eclipse.jetty.ee8");
            if (StringUtils.contains((CharSequence)newType, (CharSequence)"EE9")) {
                newType = StringUtils.replace((String)newType, (String)"EE9", (String)"EE8");
            }
            if (StringUtils.contains((CharSequence)newType, (CharSequence)"ee9")) {
                newType = StringUtils.replace((String)newType, (String)"ee9", (String)"ee8");
            }
            return newType;
        }
        return null;
    }

    private static boolean startsWith(String str, Collection<String> startList) {
        return startList.stream().anyMatch(str::startsWith);
    }

    protected void setSourceProjectLocation(File sourceProjectLocation) {
        this.sourceProjectLocation = sourceProjectLocation;
    }

    protected void setMoveDirectoryStructure(boolean moveDirectoryStructure) {
        this.moveDirectoryStructure = moveDirectoryStructure;
    }
}

