/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.shade;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.util.IOUtil;

public class MergeFilesTransformer
implements ResourceTransformer {
    private List<String> files;
    private String resource;
    private boolean preserveResourceContent = true;
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    public MergeFilesTransformer() {
    }

    public MergeFilesTransformer(List<String> files, String resource, boolean preserveResourceContent) {
        this.files = files;
        this.resource = resource;
        this.preserveResourceContent = preserveResourceContent;
    }

    public boolean canTransformResource(String resource) {
        return StringUtils.equals((String)this.resource, (String)resource);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        if (this.preserveResourceContent) {
            IOUtil.copy((InputStream)is, (OutputStream)this.data);
            this.data.write(10);
        }
    }

    public boolean hasTransformedResource() {
        return this.files.size() > 0;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (String file : this.files) {
            Files.copy(Paths.get(file, new String[0]), this.data);
            this.data.write(10);
        }
        jos.putNextEntry(new JarEntry(this.resource));
        IOUtil.copy((InputStream)new ByteArrayInputStream(this.data.toByteArray()), (OutputStream)jos);
        this.data.reset();
    }
}

