/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.shade;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class IncludeDirectoryTransformer
implements ResourceTransformer {
    public static boolean DEBUG = false;
    File directory;

    public boolean canTransformResource(String resource) {
        return false;
    }

    public boolean hasTransformedResource() {
        return this.directory != null ? this.directory.exists() : false;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        Path basePath = this.directory.toPath();
        Files.walkFileTree(basePath, new DirectoryCopier(basePath, jos));
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
    }

    private static class DirectoryCopier
    extends SimpleFileVisitor<Path> {
        private final Path basePath;
        private final JarOutputStream jos;

        public DirectoryCopier(Path basePath, JarOutputStream jos) {
            this.basePath = basePath;
            this.jos = jos;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String entryName = this.basePath.relativize(file).toString();
            this.debug("entryName = %s", entryName);
            this.jos.putNextEntry(new JarEntry(entryName));
            InputStream in = Files.newInputStream(file, StandardOpenOption.READ);
            IOUtil.copy((InputStream)in, (OutputStream)this.jos);
            IOUtil.close((InputStream)in);
            return super.visitFile(file, attrs);
        }

        public void debug(String format, Object ... args) {
            if (DEBUG) {
                System.err.printf("## " + this.getClass().getSimpleName() + " " + format + "%n", args);
            }
        }
    }
}

