/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.enforcer.rules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.util.FileUtils;

public class UniqueXmlIdDocbookRule
implements EnforcerRule {
    private Map<String, List<XmlId>> idMap = new HashMap<String, List<XmlId>>();
    private boolean shouldIfail = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            Pattern pattern = Pattern.compile(".*?(xml:id=)\"(.*?)\"", 32);
            List files = FileUtils.getFiles((File)new File("src/docbkx"), (String)"**/*.xml", (String)"");
            for (File file : files) {
                Scanner scanner = new Scanner(file).useDelimiter("\n");
                int lineNumber = 0;
                Matcher matcher = null;
                while (scanner.hasNextLine()) {
                    List<Object> idlist;
                    String line = scanner.nextLine();
                    ++lineNumber;
                    matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    String id = matcher.group(2);
                    if (!this.idMap.containsKey(id)) {
                        idlist = new ArrayList<XmlId>();
                        idlist.add(new XmlId(file.getAbsolutePath(), lineNumber));
                        this.idMap.put(id, idlist);
                        continue;
                    }
                    idlist = this.idMap.get(id);
                    idlist.add(new XmlId(file.getAbsolutePath(), lineNumber));
                    this.idMap.put(id, idlist);
                    this.shouldIfail = true;
                }
                scanner.close();
            }
            if (this.shouldIfail) {
                for (String id : this.idMap.keySet()) {
                    List<XmlId> idList = this.idMap.get(id);
                    if (idList.size() <= 1) continue;
                    System.out.println("Duplicate Global Id: " + id);
                    for (XmlId xid : idList) {
                        System.out.println(" - " + xid.getLineNumber() + ": " + xid.getFilename());
                    }
                }
                throw new EnforcerRuleException("Duplicate xml:id values found in global namespace.");
            }
        }
        catch (IOException e) {
            throw new EnforcerRuleException("EnforcerIOException", (Exception)e);
        }
    }

    public String getCacheId() {
        return "" + this.shouldIfail;
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return true;
    }

    private class XmlId {
        private String filename;
        private int lineNumber;

        public XmlId(String filename, int lineNumber) {
            this.filename = filename;
            this.lineNumber = lineNumber;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

