/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.enforcer.rules;

import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireRedhatCompatibleVersionRule
implements EnforcerRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            String packaging = (String)helper.evaluate("${project.packaging}");
            if ("pom".equals(packaging)) {
                return;
            }
            String version = (String)helper.evaluate("${project.version}");
            this.ensureValidRedhatVersion(version);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public void ensureValidRedhatVersion(String version) throws EnforcerRuleException {
        if (version.endsWith("SNAPSHOT")) {
            return;
        }
        if (version.contains("-")) {
            throw new EnforcerRuleException("The version \"" + version + "\" does not conform to the Redhat (linux packaging) version requirements.  " + "It can't have the '-' character as it has a special meaning reserved for the RPM process.");
        }
        String[] reserved = new String[]{"noarch", "nosrc", "src", "fat", "i386", "i486", "i586", "i686", "pentium", "athlon", "ia64", "x86_64", "amd64", "ia32e", "alpha", "sparc", "m68k", "ppc", "parisc", "hppa", "mips", "mipsel", "armv", "atari", "falcon", "milan", "hades", "s390", "aix", "amigaos", "bsd", "cygwin", "darwin", "freebsd", "freemint", "hp", "hpux", "irix", "linux", "machten", "macosx", "mint", "mp_ras", "nextstep", "os/390", "osf1", "osf3.2", "osf4.0", "sco_sv", "solaris", "sunos", "unix", "ux", "vm", "esa", "sun", "xtensa", "rs6000", "sgi"};
        String lversion = version.toLowerCase();
        for (String id : reserved) {
            if (!lversion.contains(id)) continue;
            throw new EnforcerRuleException("The version \"" + version + "\" does not conform to the Redhat (linux packaging) version requirements.  " + "It can't use the RPM reserved word \"" + id + "\".");
        }
    }

    public String getCacheId() {
        return "redhat-version";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return true;
    }
}

