/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.m4e.eclipse.signing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.UUID;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.dash.m4e.eclipse.signing.AbstractEclipseSigningMojo;

public class SignMojo
extends AbstractEclipseSigningMojo {
    protected String execute;
    protected String inputFile;
    protected String outputFile;
    protected String signerInputDirectory;
    protected String signerOutputDirectory;
    protected int zipCheckInterval;
    protected int maxZipChecks;
    protected PlexusContainer plexus;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block8: {
            if (!FileUtils.fileExists((String)this.inputFile)) {
                throw new MojoExecutionException("zip file does not exist - " + this.inputFile);
            }
            try {
                if (!FileUtils.fileExists((String)FileUtils.dirname((String)this.outputFile))) {
                    this.info("creating directory to hold signed artifact");
                    FileUtils.mkdir((String)FileUtils.dirname((String)this.outputFile));
                }
                System.err.println("input file " + this.inputFile);
                File in = new File(this.inputFile);
                ZipUnArchiver unarchive = (ZipUnArchiver)this.plexus.lookup(ZipUnArchiver.ROLE, "zip");
                File dest = new File(in.getParentFile(), "repository");
                dest.mkdir();
                unarchive.setDestDirectory(dest);
                unarchive.setSourceFile(in);
                unarchive.setFileSelectors(new FileSelector[]{new FileSelector(){

                    public boolean isSelected(FileInfo arg0) throws IOException {
                        return !arg0.getName().endsWith(".pack.gz");
                    }
                }});
                System.err.println(unarchive.getSourceFile() + " - unarchived into - " + unarchive.getDestDirectory());
                System.err.println(unarchive.getSourceFile().getAbsolutePath() + " unarchived into " + unarchive.getDestDirectory().getAbsolutePath());
                unarchive.extract();
                FileUtils.rename((File)in, (File)new File(in.getParentFile(), in.getName() + "-before-removing-pack-gz.zip"));
                ZipArchiver archiver = (ZipArchiver)this.plexus.lookup(ZipArchiver.ROLE, "zip");
                DefaultFileSet fileset = new DefaultFileSet();
                fileset.setDirectory(unarchive.getDestDirectory());
                fileset.setFileSelectors(new FileSelector[]{new FileSelector(){

                    public boolean isSelected(FileInfo arg0) throws IOException {
                        System.err.println("looking at " + arg0.getName());
                        return !arg0.getName().endsWith(".pack.gz");
                    }
                }});
                archiver.addFileSet((FileSet)fileset);
                File tmpDest = new File(in.getParentFile(), in.getName() + "-after-removing.zip");
                archiver.setDestFile(tmpDest);
                System.err.println("....archive " + unarchive.getDestDirectory() + " into " + new File(this.inputFile).getAbsolutePath());
                archiver.createArchive();
                FileUtils.copyFile((File)tmpDest, (File)in);
                if ("local".equals(this.execute)) {
                    this.signLocally();
                } else if ("remote".equals(this.execute)) {
                    this.signRemotely();
                }
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                if (e instanceof MojoExecutionException) {
                    throw (MojoExecutionException)e;
                }
                if (!(e instanceof MojoFailureException)) break block8;
                throw (MojoFailureException)e;
            }
        }
    }

    private void signLocally() throws Exception {
        String liner;
        this.signerInputDirectory = this.signerInputDirectory + File.separator + UUID.randomUUID().toString();
        this.signerOutputDirectory = this.signerInputDirectory + File.separator + "signed";
        FileUtils.mkdir((String)this.signerInputDirectory);
        if (!FileUtils.fileExists((String)this.signerInputDirectory)) {
            throw new MojoFailureException("Unable to create the directory " + this.signerInputDirectory);
        }
        FileUtils.mkdir((String)this.signerOutputDirectory);
        FileUtils.copyFile((File)new File(this.inputFile), (File)new File(this.signerInputDirectory + File.separator + FileUtils.filename((String)this.inputFile)));
        Process pc = Runtime.getRuntime().exec(new String[]{"/bin/chmod", "-R", "ugo+rw", this.signerInputDirectory});
        pc.waitFor();
        Process ps = Runtime.getRuntime().exec(new String[]{"/usr/bin/sign", this.signerInputDirectory + File.separator + FileUtils.filename((String)this.inputFile), "nomail", this.signerOutputDirectory});
        BufferedReader is = new BufferedReader(new InputStreamReader(ps.getInputStream()));
        while ((liner = is.readLine()) != null) {
            System.out.println(liner);
        }
        System.out.println("In Main after EOF");
        System.out.flush();
        try {
            ps.waitFor();
        }
        catch (InterruptedException e) {
            System.err.println(e);
            return;
        }
        boolean keepChecking = true;
        int count = 0;
        while (keepChecking && count < this.maxZipChecks) {
            try {
                this.info("monitoring for signed file in " + this.signerOutputDirectory);
                ++count;
                Thread.sleep(this.zipCheckInterval);
                List signedDirList = FileUtils.getFileNames((File)new File(this.signerOutputDirectory), (String)"**", null, (boolean)true);
                this.info("signed dir output: " + signedDirList.size());
                for (String line : signedDirList) {
                    this.getLog().info((CharSequence)("-> " + line));
                }
                if (signedDirList.size() != 1) continue;
                this.info("found the signed file");
                keepChecking = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (count == this.maxZipChecks) {
            this.getLog().error((CharSequence)"signer process never signaled completion");
            FileUtils.deleteDirectory((String)this.signerInputDirectory);
            return;
        }
        this.getLog().info((CharSequence)("copying signed artifact to :" + this.outputFile));
        FileUtils.copyFile((File)new File(this.signerOutputDirectory + File.separator + FileUtils.filename((String)this.inputFile)), (File)new File(this.outputFile));
        FileUtils.deleteDirectory((String)this.signerInputDirectory);
    }

    private void signRemotely() throws Exception {
        Wagon wagon = this.createWagon(this.serverId, this.getWagonUrl());
        CommandExecutor exec = this.getCommandExecutor(wagon);
        this.signerInputDirectory = UUID.randomUUID().toString();
        this.signerOutputDirectory = this.signerInputDirectory + File.separator + "signed";
        this.info("creating remote input directory");
        exec.executeCommand("/bin/mkdir -p " + this.signerInputDirectory);
        this.info("setting permissions");
        exec.executeCommand("/bin/mkdir -p " + this.signerOutputDirectory);
        this.info("copying file to sign to remote directory");
        wagon.put(new File(this.inputFile), this.signerInputDirectory + File.separator + FileUtils.filename((String)this.inputFile));
        this.info("setting permissions on file");
        exec.executeCommand("/bin/chmod -R ugo+rw " + this.signerInputDirectory);
        this.info("calling sign script");
        this.info("/usr/bin/sign " + this.adjustToWagonPath(this.signerInputDirectory) + File.separator + FileUtils.filename((String)this.inputFile) + " nomail signed");
        Streams s = exec.executeCommand("/usr/bin/sign " + this.adjustToWagonPath(this.signerInputDirectory) + File.separator + FileUtils.filename((String)this.inputFile) + " nomail signed", false);
        this.info("sign script output\n" + s.getOut());
        boolean keepChecking = true;
        int count = 0;
        while (keepChecking && count < this.maxZipChecks) {
            try {
                this.info("monitoring for signed file");
                ++count;
                Thread.sleep(this.zipCheckInterval);
                List signedDirList = exec.getFileList(this.signerOutputDirectory);
                this.info("signed dir output:");
                for (String line : signedDirList) {
                    this.getLog().info((CharSequence)("-> " + line));
                }
                if (signedDirList.size() != 1) continue;
                this.info("found the signed file");
                keepChecking = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (count == this.maxZipChecks) {
            this.getLog().error((CharSequence)"signer process never signaled completion");
            this.cleanup(exec, this.signerInputDirectory);
            return;
        }
        this.getLog().info((CharSequence)("copying signed artifact to :" + this.outputFile));
        wagon.get(this.signerOutputDirectory + File.separator + FileUtils.filename((String)this.inputFile), new File(this.outputFile));
        this.cleanup(exec, this.signerInputDirectory);
    }

    private void cleanup(CommandExecutor exec, String signerInputDirectory) throws Exception {
        exec.executeCommand("/bin/rm -Rf " + this.adjustToWagonPath(signerInputDirectory));
    }

    private void info(String log) {
        this.getLog().info((CharSequence)("[SIGN] " + log));
    }
}

