/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.m4e.eclipse.signing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.eclipse.dash.m4e.eclipse.signing.AbstractEclipseSigningMojo;

public class RepackMojo
extends AbstractEclipseSigningMojo {
    private static final String __PACK_JAR = "org.eclipse.equinox.p2.jarprocessor_1.0.200.v20100503a.jar";
    private static final String __PACK_PROPERTIES = "pack.properties";
    protected String inputFile;
    protected String packedOutputDirectory;
    protected String stagingDirectory;
    protected String pack200;
    protected String javaExecutable;
    protected MavenProject project;
    protected String packExclude;
    protected boolean conditionOnly;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!FileUtils.fileExists((String)this.inputFile)) {
            throw new MojoFailureException("file to pack does not exist! -> " + this.inputFile);
        }
        if (!FileUtils.fileExists((String)this.packedOutputDirectory)) {
            this.info("creating directory to hold packed output");
            FileUtils.mkdir((String)this.packedOutputDirectory);
        }
        if (!FileUtils.fileExists((String)this.stagingDirectory)) {
            this.info("creating directory to hold pack staging bits");
            FileUtils.mkdir((String)this.stagingDirectory);
        }
        if (new File(this.inputFile).isDirectory()) {
            this.setupPackProperties(new File(this.inputFile), null);
            ZipArchiver zipper = new ZipArchiver();
            File destFile = new File(this.project.getBuild().getDirectory(), "repository-zipped/" + this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip");
            try {
                destFile.getParentFile().mkdirs();
                zipper.addDirectory(new File(this.inputFile));
                zipper.setDestFile(destFile);
                zipper.createArchive();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error packing product", e);
            }
            this.inputFile = destFile.getAbsolutePath();
        }
        try {
            this.packLocally();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void setupPackProperties(File targetRepo, File packPropertiesSource) throws MojoExecutionException {
        Properties props = new Properties();
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            if (packPropertiesSource != null && packPropertiesSource.canRead()) {
                props.load(inStream);
            } else {
                props.put("pack200.default.args", "-E4");
            }
            props.put("pack.excludes", this.getPackExcluded(targetRepo).toString());
            File out = new File(targetRepo, __PACK_PROPERTIES);
            if (!out.exists()) {
                out.createNewFile();
            }
            outStream = new FileOutputStream(out);
            props.save(outStream, "Pack.properties generated by the packmojo");
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to setup the pack.properties file", (Exception)ioe);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getPackExcluded(File targetRepoDirectory) {
        StringBuilder patterns = new StringBuilder("artifacts.jar,content.jar");
        if (this.packExclude != null) {
            patterns.append("," + this.packExclude);
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(targetRepoDirectory);
        StringTokenizer tokenizer = new StringTokenizer(patterns.toString(), ", \r\n\t", false);
        String[] incls = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String tok;
            incls[i] = tok = tokenizer.nextToken();
            ++i;
        }
        scanner.setIncludes(incls);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        StringBuilder excluded = null;
        for (String incl : includedFiles) {
            incl = incl.replace('\\', '/');
            if (excluded == null) {
                excluded = new StringBuilder(incl);
                continue;
            }
            excluded.append("," + incl);
        }
        return excluded.toString();
    }

    private String[] generatePackExecuteString(String jarPackerLoc, String toPack, String outputDirectory) {
        return new String[]{"-Dorg.eclipse.update.jarprocessor.pack200=" + this.pack200, "-jar", jarPackerLoc, "-processAll", "-pack", "-repack", "-verbose", "-outputDir", outputDirectory, toPack};
    }

    private void positionPackJarForExecution() throws MojoExecutionException {
        this.info("getting jar packer into position");
        URL jarPacker = ((Object)((Object)this)).getClass().getClassLoader().getResource(__PACK_JAR);
        URL jarProperties = ((Object)((Object)this)).getClass().getClassLoader().getResource(__PACK_PROPERTIES);
        try {
            FileUtils.copyURLToFile((URL)jarPacker, (File)new File(this.stagingDirectory + File.separator + __PACK_JAR));
            FileUtils.copyURLToFile((URL)jarProperties, (File)new File(this.stagingDirectory + File.separator + __PACK_PROPERTIES));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("unable to position jar packer", (Exception)e);
        }
    }

    private void packLocally() throws Exception {
        if (!FileUtils.fileExists((String)this.packedOutputDirectory)) {
            this.info("creating directory to hold packed output");
            FileUtils.mkdir((String)this.packedOutputDirectory);
        }
        try {
            String packTempDirectory = this.stagingDirectory + File.separator + UUID.randomUUID().toString();
            FileUtils.mkdir((String)packTempDirectory);
            FileUtils.copyFileToDirectory((String)this.inputFile, (String)packTempDirectory);
            CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            this.positionPackJarForExecution();
            Commandline pack = new Commandline();
            pack.setWorkingDirectory(FileUtils.dirname((String)packTempDirectory));
            pack.setExecutable(this.javaExecutable);
            pack.addArguments(this.generatePackExecuteString(this.stagingDirectory + "/" + __PACK_JAR, this.inputFile, this.packedOutputDirectory));
            this.info("executing pack200, output at end of execution : " + pack);
            CommandLineUtils.executeCommandLine((Commandline)pack, (StreamConsumer)out, (StreamConsumer)err);
            String packErrput = IOUtil.toString((Reader)new StringReader(err.getOutput()));
            String packOutput = IOUtil.toString((Reader)new StringReader(out.getOutput()));
            this.info("pack200 output:\n" + packOutput);
            if (packErrput != null || !"".equals(packErrput)) {
                this.getLog().error((CharSequence)packErrput);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().error((Throwable)e);
        }
    }

    private void info(String log) {
        this.getLog().info((CharSequence)("[PACK] " + log));
    }
}

