/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.m4e.eclipse.signing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.eclipse.jetty.toolchain:eclipse-signing-maven-plugin:1.0.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Jetty :: Toolchain :: Eclipse Signing Maven Plugin", 0);
        this.append(sb, "Plugin for signing code on the eclipse build servers.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "fixCheckSums".equals(this.goal)) {
            this.append(sb, "eclipse-signing:fixCheckSums", 0);
            this.append(sb, "This plugin walks through a p2 repository and repairs the artifacts.xml.\nIt also insert the property <property name='publishPackFilesAsSiblings' value='true'/> and the mapping rules if they were not present already:\n<rule filter='(& (classifier=osgi.bundle) (format=packed))' output='${repoUrl}/plugins/${id}_${version}.jar.pack.gz'/> <rule filter='(& (classifier=org.eclipse.update.feature) (format=packed))' output='${repoUrl}/features/${id}_${version}.jar.pack.gz'/>", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifactsXml (Default: ${project.build.directory}/checksumFix/artifacts.xml)", 2);
                this.append(sb, "checksum file", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputFile (Default: ${project.build.directory}/packed/site_assembly.zip)", 2);
                this.append(sb, "zip file to get checksum'ed", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile (Default: ${project.build.directory}/fixed/site_assembly.zip)", 2);
                this.append(sb, "zip file to get checksum'ed", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "unpackPath (Default: /)", 2);
                this.append(sb, "unpack path for artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "unzipDir (Default: ${project.build.directory}/checksumFix)", 2);
                this.append(sb, "zip file to get checksum'ed", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonHost", 2);
                this.append(sb, "host portion of the wagon connection Example: build.eclipse.org", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonPath", 2);
                this.append(sb, "path portion of the wagon connection Example: /home/data/users/jmcconnell", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonProtocol", 2);
                this.append(sb, "protocol for the wagon connection Example: scp://", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonTimeout (Default: 900000)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "eclipse-signing:help", 0);
            this.append(sb, "Display help information on eclipse-signing-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0eclipse-signing:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "pack".equals(this.goal)) {
            this.append(sb, "eclipse-signing:pack", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "conditionOnly (Default: false)", 2);
                this.append(sb, "when true, remove the pack.gz files to make sure no confusion will happen later.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputFile (Default: ${project.build.directory}/site_assembly.zip)", 2);
                this.append(sb, "zip file to be packed", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaExecutable (Default: /usr/local/bin/java)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "pack200 (Default: /shared/common/jdk-1.5.0-22.x86_64/bin)", 2);
                this.append(sb, "location of pack200", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "packedOutputDirectory (Default: ${project.build.directory}/packed)", 2);
                this.append(sb, "directory monitor for artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "packExclude", 2);
                this.append(sb, "List of patterns for a directory scanner to select the jars that must not be packed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "stagingDirectory (Default: ${project.build.directory}/pack-stage)", 2);
                this.append(sb, "directory for required bits", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonHost", 2);
                this.append(sb, "host portion of the wagon connection Example: build.eclipse.org", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonPath", 2);
                this.append(sb, "path portion of the wagon connection Example: /home/data/users/jmcconnell", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonProtocol", 2);
                this.append(sb, "protocol for the wagon connection Example: scp://", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonTimeout (Default: 900000)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "repack".equals(this.goal)) {
            this.append(sb, "eclipse-signing:repack", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "conditionOnly (Default: false)", 2);
                this.append(sb, "when true, remove the pack.gz files to make sure no confusion will happen later.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputFile (Default: ${project.build.directory}/signed/site_assembly.zip)", 2);
                this.append(sb, "zip file to be packed", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaExecutable (Default: /usr/local/bin/java)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "pack200 (Default: /shared/common/jdk-1.5.0-22.x86_64/bin)", 2);
                this.append(sb, "location of pack200", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "packedOutputDirectory (Default: ${project.build.directory}/packed)", 2);
                this.append(sb, "directory monitor for artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "packExclude", 2);
                this.append(sb, "List of patterns for a directory scanner to select the jars that must not be packed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "stagingDirectory (Default: ${project.build.directory}/pack-stage)", 2);
                this.append(sb, "directory for required bits", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonHost", 2);
                this.append(sb, "host portion of the wagon connection Example: build.eclipse.org", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonPath", 2);
                this.append(sb, "path portion of the wagon connection Example: /home/data/users/jmcconnell", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonProtocol", 2);
                this.append(sb, "protocol for the wagon connection Example: scp://", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonTimeout (Default: 900000)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sign".equals(this.goal)) {
            this.append(sb, "eclipse-signing:sign", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "execute (Default: local)", 2);
                this.append(sb, "Accepted values are 'local' and 'remote'", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputFile (Default: ${project.build.directory}/packed/site_assembly.zip)", 2);
                this.append(sb, "zip file to get signed", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxZipChecks (Default: 30)", 2);
                this.append(sb, "directory monitor for signed artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile (Default: ${project.build.directory}/signed/site_assembly.zip)", 2);
                this.append(sb, "zip file to get signed", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "signerInputDirectory", 2);
                this.append(sb, "directory to send artifact to be signed should be akin to: /home/data/httpd/download-staging.priv/rt/<project>", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "signerOutputDirectory", 2);
                this.append(sb, "directory monitor for signed artifact", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonHost", 2);
                this.append(sb, "host portion of the wagon connection Example: build.eclipse.org", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonPath", 2);
                this.append(sb, "path portion of the wagon connection Example: /home/data/users/jmcconnell", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonProtocol", 2);
                this.append(sb, "protocol for the wagon connection Example: scp://", 3);
                this.append(sb, "", 0);
                this.append(sb, "wagonTimeout (Default: 900000)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "zipCheckInterval (Default: 60000)", 2);
                this.append(sb, "directory monitor interval for signed artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

