/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.m4e.eclipse.signing;

import java.io.File;
import java.net.InetAddress;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.wagon.shared.WagonUtils;

public abstract class AbstractEclipseSigningMojo
extends AbstractMojo {
    protected WagonManager wagonManager;
    protected Settings settings;
    protected String wagonProtocol;
    protected String wagonHost;
    protected String wagonPath;
    protected String serverId;
    protected int wagonTimeout;

    protected boolean runningOnBuildMachine() throws Exception {
        return InetAddress.getLocalHost().getHostName().equals("build.eclipse.org");
    }

    protected String adjustToWagonPath(String location) {
        return this.wagonPath + File.separator + location;
    }

    protected String getWagonUrl() throws Exception {
        if (this.wagonProtocol == null || this.wagonHost == null || this.wagonPath == null) {
            throw new IllegalArgumentException("missing wagon configuration bits, unable to operate remotely");
        }
        if (this.runningOnBuildMachine()) {
            return this.wagonProtocol + this.wagonPath;
        }
        return this.wagonProtocol + this.wagonHost + this.wagonPath;
    }

    protected Wagon createWagon(String id, String url) throws MojoExecutionException {
        try {
            return WagonUtils.createWagon((String)id, (String)url, (WagonManager)this.wagonManager, (Settings)this.settings, (Log)this.getLog());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create a Wagon instance for " + url, e);
        }
    }

    protected CommandExecutor getCommandExecutor(Wagon wagon) throws Exception {
        if (!(wagon instanceof CommandExecutor)) {
            throw new MojoExecutionException("unable to operate remotely, requires wagon capable of invoking commands");
        }
        CommandExecutor exec = (CommandExecutor)wagon;
        exec.setTimeout(this.wagonTimeout);
        return exec;
    }
}

