/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.continuation.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;

public abstract class ContinuationBase
extends TestCase {
    protected SuspendServlet _servlet = new SuspendServlet();
    protected int _port;
    private static ContinuationListener __listener = new ContinuationListener(){

        public void onComplete(Continuation continuation) {
            ((HttpServletResponse)continuation.getServletResponse()).addHeader("history", "onComplete");
        }

        public void onTimeout(Continuation continuation) {
            ((HttpServletResponse)continuation.getServletResponse()).addHeader("history", "onTimeout");
            continuation.resume();
        }
    };

    protected void doNormal(String type) throws Exception {
        String response = this.process(null, null);
        this.assertContains(type, response);
        this.assertContains("NORMAL", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertNotContains("history: onComplete", response);
    }

    protected void doSleep() throws Exception {
        String response = this.process("sleep=200", null);
        this.assertContains("SLEPT", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertNotContains("history: onComplete", response);
    }

    protected void doSuspend() throws Exception {
        String response = this.process("suspend=200", null);
        this.assertContains("TIMEOUT", response);
        this.assertContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    protected void doSuspendWaitResume() throws Exception {
        String response = this.process("suspend=200&resume=10", null);
        this.assertContains("RESUMED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    protected void doSuspendResume() throws Exception {
        String response = this.process("suspend=200&resume=0", null);
        this.assertContains("RESUMED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    protected void doSuspendWaitComplete() throws Exception {
        String response = this.process("suspend=200&complete=10", null);
        this.assertContains("COMPLETED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    protected void doSuspendComplete() throws Exception {
        String response = this.process("suspend=200&complete=0", null);
        this.assertContains("COMPLETED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    protected void doSuspendWaitResumeSuspendWaitResume() throws Exception {
        String response = this.process("suspend=1000&resume=10&suspend2=1000&resume2=10", null);
        ContinuationBase.assertEquals((int)2, (int)this.count(response, "history: suspend"));
        ContinuationBase.assertEquals((int)2, (int)this.count(response, "history: resume"));
        ContinuationBase.assertEquals((int)0, (int)this.count(response, "history: onTimeout"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onComplete"));
        this.assertContains("RESUMED", response);
    }

    protected void doSuspendWaitResumeSuspendComplete() throws Exception {
        String response = this.process("suspend=1000&resume=10&suspend2=1000&complete2=10", null);
        ContinuationBase.assertEquals((int)2, (int)this.count(response, "history: suspend"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: resume"));
        ContinuationBase.assertEquals((int)0, (int)this.count(response, "history: onTimeout"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onComplete"));
        this.assertContains("COMPLETED", response);
    }

    protected void doSuspendWaitResumeSuspend() throws Exception {
        String response = this.process("suspend=1000&resume=10&suspend2=10", null);
        ContinuationBase.assertEquals((int)2, (int)this.count(response, "history: suspend"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: resume"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onTimeout"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onComplete"));
        this.assertContains("TIMEOUT", response);
    }

    protected void doSuspendTimeoutSuspendResume() throws Exception {
        String response = this.process("suspend=10&suspend2=1000&resume2=10", null);
        ContinuationBase.assertEquals((int)2, (int)this.count(response, "history: suspend"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: resume"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onTimeout"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onComplete"));
        this.assertContains("RESUMED", response);
    }

    protected void doSuspendTimeoutSuspendComplete() throws Exception {
        String response = this.process("suspend=10&suspend2=1000&complete2=10", null);
        ContinuationBase.assertEquals((int)2, (int)this.count(response, "history: suspend"));
        ContinuationBase.assertEquals((int)0, (int)this.count(response, "history: resume"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onTimeout"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onComplete"));
        this.assertContains("COMPLETED", response);
    }

    protected void doSuspendTimeoutSuspend() throws Exception {
        String response = this.process("suspend=10&suspend2=10", null);
        ContinuationBase.assertEquals((int)2, (int)this.count(response, "history: suspend"));
        ContinuationBase.assertEquals((int)0, (int)this.count(response, "history: resume"));
        ContinuationBase.assertEquals((int)2, (int)this.count(response, "history: onTimeout"));
        ContinuationBase.assertEquals((int)1, (int)this.count(response, "history: onComplete"));
        this.assertContains("TIMEOUT", response);
    }

    protected void doSuspendThrowResume() throws Exception {
        String response = this.process("suspend=200&resume=10&undispatch=true", null);
        this.assertContains("RESUMED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    protected void doSuspendResumeThrow() throws Exception {
        String response = this.process("suspend=200&resume=0&undispatch=true", null);
        this.assertContains("RESUMED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    protected void doSuspendThrowComplete() throws Exception {
        String response = this.process("suspend=200&complete=10&undispatch=true", null);
        this.assertContains("COMPLETED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    protected void doSuspendCompleteThrow() throws Exception {
        String response = this.process("suspend=200&complete=0&undispatch=true", null);
        this.assertContains("COMPLETED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertContains("history: onComplete", response);
    }

    private int count(String responses, String substring) {
        int count = 0;
        int i = responses.indexOf(substring);
        while (i >= 0) {
            ++count;
            i = responses.indexOf(substring, i + substring.length());
        }
        return count;
    }

    protected void assertContains(String content, String response) {
        ContinuationBase.assertEquals((String)"HTTP/1.1 200 OK", (String)response.substring(0, 15));
        if (response.indexOf(content, 15) < 0) {
            System.err.println("'" + content + "' NOT IN:\n" + response + "\n--");
            ContinuationBase.assertTrue((boolean)false);
        }
    }

    protected void assertNotContains(String content, String response) {
        ContinuationBase.assertEquals((String)"HTTP/1.1 200 OK", (String)response.substring(0, 15));
        if (response.indexOf(content, 15) >= 0) {
            System.err.println("'" + content + "' IS IN:\n" + response + "'\n--");
            ContinuationBase.assertTrue((boolean)false);
        }
    }

    public synchronized String process(String query, String content) throws Exception {
        String request = "GET /";
        if (query != null) {
            request = request + "?" + query;
        }
        request = request + " HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n";
        if (content != null) {
            request = request + "Content-Length: " + content.length() + "\r\n";
        }
        request = request + "\r\n" + content;
        Socket socket = new Socket("localhost", this._port);
        socket.getOutputStream().write(request.getBytes("UTF-8"));
        String response = this.toString(socket.getInputStream());
        return response;
    }

    protected abstract String toString(InputStream var1) throws IOException;

    private static class SuspendServlet
    extends HttpServlet {
        private Timer _timer = new Timer();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
            final Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            response.addHeader("history", continuation.getClass().toString());
            int read_before = 0;
            long sleep_for = -1L;
            long suspend_for = -1L;
            long suspend2_for = -1L;
            long resume_after = -1L;
            long resume2_after = -1L;
            long complete_after = -1L;
            long complete2_after = -1L;
            boolean undispatch = false;
            if (request.getParameter("read") != null) {
                read_before = Integer.parseInt(request.getParameter("read"));
            }
            if (request.getParameter("sleep") != null) {
                sleep_for = Integer.parseInt(request.getParameter("sleep"));
            }
            if (request.getParameter("suspend") != null) {
                suspend_for = Integer.parseInt(request.getParameter("suspend"));
            }
            if (request.getParameter("suspend2") != null) {
                suspend2_for = Integer.parseInt(request.getParameter("suspend2"));
            }
            if (request.getParameter("resume") != null) {
                resume_after = Integer.parseInt(request.getParameter("resume"));
            }
            if (request.getParameter("resume2") != null) {
                resume2_after = Integer.parseInt(request.getParameter("resume2"));
            }
            if (request.getParameter("complete") != null) {
                complete_after = Integer.parseInt(request.getParameter("complete"));
            }
            if (request.getParameter("complete2") != null) {
                complete2_after = Integer.parseInt(request.getParameter("complete2"));
            }
            if (request.getParameter("undispatch") != null) {
                undispatch = Boolean.parseBoolean(request.getParameter("undispatch"));
            }
            if (continuation.isInitial()) {
                if (read_before > 0) {
                    byte[] buf = new byte[read_before];
                    request.getInputStream().read(buf);
                } else if (read_before < 0) {
                    ServletInputStream in = request.getInputStream();
                    int b = in.read();
                    while (b != -1) {
                        b = in.read();
                    }
                }
                if (suspend_for >= 0L) {
                    if (suspend_for > 0L) {
                        continuation.setTimeout(suspend_for);
                    }
                    continuation.addContinuationListener(__listener);
                    response.addHeader("history", "suspend");
                    continuation.suspend((ServletResponse)response);
                    if (complete_after > 0L) {
                        TimerTask complete = new TimerTask(){

                            @Override
                            public void run() {
                                try {
                                    response.setStatus(200);
                                    response.getOutputStream().println("COMPLETED\n");
                                    continuation.complete();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        Timer timer = this._timer;
                        synchronized (timer) {
                            this._timer.schedule(complete, complete_after);
                        }
                    } else if (complete_after == 0L) {
                        response.setStatus(200);
                        response.getOutputStream().println("COMPLETED\n");
                        continuation.complete();
                    } else if (resume_after > 0L) {
                        TimerTask resume = new TimerTask(){

                            @Override
                            public void run() {
                                ((HttpServletResponse)continuation.getServletResponse()).addHeader("history", "resume");
                                continuation.resume();
                            }
                        };
                        Timer timer = this._timer;
                        synchronized (timer) {
                            this._timer.schedule(resume, resume_after);
                        }
                    } else if (resume_after == 0L) {
                        ((HttpServletResponse)continuation.getServletResponse()).addHeader("history", "resume");
                        continuation.resume();
                    }
                    if (undispatch) {
                        continuation.undispatch();
                    }
                } else if (sleep_for >= 0L) {
                    try {
                        Thread.sleep(sleep_for);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    response.setStatus(200);
                    response.getOutputStream().println("SLEPT\n");
                } else {
                    response.setStatus(200);
                    response.getOutputStream().println("NORMAL\n");
                }
            } else {
                if (suspend2_for >= 0L && request.getAttribute("2nd") == null) {
                    request.setAttribute("2nd", (Object)"cycle");
                    if (suspend2_for > 0L) {
                        continuation.setTimeout(suspend2_for);
                    }
                    response.addHeader("history", "suspend");
                    continuation.suspend((ServletResponse)response);
                    if (complete2_after > 0L) {
                        TimerTask complete = new TimerTask(){

                            @Override
                            public void run() {
                                try {
                                    response.setStatus(200);
                                    response.getOutputStream().println("COMPLETED\n");
                                    continuation.complete();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        Timer timer = this._timer;
                        synchronized (timer) {
                            this._timer.schedule(complete, complete2_after);
                        }
                    } else if (complete2_after == 0L) {
                        response.setStatus(200);
                        response.getOutputStream().println("COMPLETED\n");
                        continuation.complete();
                    } else if (resume2_after > 0L) {
                        TimerTask resume = new TimerTask(){

                            @Override
                            public void run() {
                                response.addHeader("history", "resume");
                                continuation.resume();
                            }
                        };
                        Timer timer = this._timer;
                        synchronized (timer) {
                            this._timer.schedule(resume, resume2_after);
                        }
                    } else if (resume2_after == 0L) {
                        response.addHeader("history", "resume");
                        continuation.resume();
                    }
                    if (undispatch) {
                        continuation.undispatch();
                    }
                    return;
                }
                if (continuation.isExpired()) {
                    response.setStatus(200);
                    response.getOutputStream().println("TIMEOUT\n");
                } else if (continuation.isResumed()) {
                    response.setStatus(200);
                    response.getOutputStream().println("RESUMED\n");
                } else {
                    response.setStatus(200);
                    response.getOutputStream().println("unknown???\n");
                }
            }
        }
    }
}

