/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.server.NPNServerConnectionFactory;
import org.eclipse.jetty.spdy.server.SPDYServerConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SPDYServerConnector
extends ServerConnector {
    public SPDYServerConnector(Server server, ServerSessionFrameListener listener) {
        this(server, null, listener);
    }

    public SPDYServerConnector(Server server, SslContextFactory sslContextFactory, ServerSessionFrameListener listener) {
        ConnectionFactory[] connectionFactoryArray;
        if (sslContextFactory == null) {
            ConnectionFactory[] connectionFactoryArray2 = new ConnectionFactory[1];
            connectionFactoryArray = connectionFactoryArray2;
            connectionFactoryArray2[0] = new SPDYServerConnectionFactory(2, listener);
        } else {
            ConnectionFactory[] connectionFactoryArray3 = new ConnectionFactory[4];
            connectionFactoryArray3[0] = new NPNServerConnectionFactory("spdy/3", "spdy/2", "http/1.1");
            connectionFactoryArray3[1] = new HttpConnectionFactory();
            connectionFactoryArray3[2] = new SPDYServerConnectionFactory(2, listener);
            connectionFactoryArray = connectionFactoryArray3;
            connectionFactoryArray3[3] = new SPDYServerConnectionFactory(3, listener);
        }
        super(server, sslContextFactory, connectionFactoryArray);
        if (this.getConnectionFactory(NPNServerConnectionFactory.class) != null) {
            ((NPNServerConnectionFactory)((Object)this.getConnectionFactory(NPNServerConnectionFactory.class))).setDefaultProtocol("http/1.1");
        }
    }
}

