/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.spdy.server.NextProtoNegoServerConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NPNServerConnectionFactory
extends AbstractConnectionFactory {
    private static final Logger LOG = Log.getLogger(NPNServerConnectionFactory.class);
    private final List<String> _protocols;
    private String _defaultProtocol;

    public NPNServerConnectionFactory(String ... protocols) {
        super("npn");
        this._protocols = Arrays.asList(protocols);
        try {
            if (NextProtoNego.class.getClassLoader() != null) {
                LOG.warn("NextProtoNego not from bootloader classloader: " + NextProtoNego.class.getClassLoader(), new Object[0]);
                throw new IllegalStateException("NextProtoNego not on bootloader");
            }
        }
        catch (Throwable th) {
            LOG.warn("NextProtoNego not available: " + th, new Object[0]);
            throw new IllegalStateException("NextProtoNego not available", th);
        }
    }

    public String getDefaultProtocol() {
        return this._defaultProtocol;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        this._defaultProtocol = defaultProtocol;
    }

    public List<String> getProtocols() {
        return this._protocols;
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        String dft;
        List protocols = this._protocols;
        if (protocols == null || protocols.size() == 0) {
            protocols = connector.getProtocols();
            Iterator i = protocols.iterator();
            while (i.hasNext()) {
                String protocol = (String)i.next();
                if (!protocol.startsWith("SSL-") && !protocol.equals("NPN")) continue;
                i.remove();
            }
        }
        if ((dft = this._defaultProtocol) == null) {
            dft = this._protocols.get(0);
        }
        return this.configure(new NextProtoNegoServerConnection((SslConnection.DecryptedEndPoint)endPoint, connector, protocols, this._defaultProtocol), connector, endPoint);
    }

    public String toString() {
        return String.format("%s@%x{%s,%s,%s}", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getProtocol(), this.getDefaultProtocol(), this.getProtocols());
    }
}

