/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import java.net.CookieStore;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngine;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTPProxyEngine
extends ProxyEngine {
    private static final Logger LOG = Log.getLogger(HTTPProxyEngine.class);
    private static final Callback LOGGING_CALLBACK = new LoggingCallback();
    private final HttpClient httpClient;

    public HTTPProxyEngine(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.configureHttpClient(httpClient);
    }

    private void configureHttpClient(HttpClient httpClient) {
        httpClient.setFollowRedirects(false);
        httpClient.setCookieStore((CookieStore)new HttpCookieStore.Empty());
    }

    @Override
    public StreamFrameListener proxy(Stream clientStream, SynInfo clientSynInfo, ProxyEngineSelector.ProxyServerInfo proxyServerInfo) {
        short version = clientStream.getSession().getVersion();
        String method = clientSynInfo.getHeaders().get(HTTPSPDYHeader.METHOD.name(version)).value();
        String path = clientSynInfo.getHeaders().get(HTTPSPDYHeader.URI.name(version)).value();
        Fields headers = new Fields(clientSynInfo.getHeaders(), false);
        this.removeHopHeaders(headers);
        this.addRequestProxyHeaders(clientStream, headers);
        this.customizeRequestHeaders(clientStream, headers);
        String host = proxyServerInfo.getHost();
        int port = proxyServerInfo.getAddress().getPort();
        LOG.debug("Sending HTTP request to: {}", new Object[]{host + ":" + port});
        final Request request = this.httpClient.newRequest(host, port).path(path).method(HttpMethod.fromString((String)method));
        this.addNonSpdyHeadersToRequest(version, headers, request);
        if (!clientSynInfo.isClose()) {
            request.content((ContentProvider)new DeferredContentProvider(new ByteBuffer[0]));
        }
        this.sendRequest(clientStream, request);
        return new StreamFrameListener.Adapter(){

            public void onReply(Stream stream, ReplyInfo replyInfo) {
                throw new UnsupportedOperationException("Not Yet Implemented");
            }

            public void onHeaders(Stream stream, HeadersInfo headersInfo) {
                throw new UnsupportedOperationException("Not Yet Implemented");
            }

            public void onData(Stream clientStream, DataInfo clientDataInfo) {
                LOG.debug("received clientDataInfo: {} for stream: {}", new Object[]{clientDataInfo, clientStream});
                DeferredContentProvider contentProvider = (DeferredContentProvider)request.getContent();
                contentProvider.offer(clientDataInfo.asByteBuffer(true));
                if (clientDataInfo.isClose()) {
                    contentProvider.close();
                }
            }
        };
    }

    private void sendRequest(final Stream clientStream, Request request) {
        request.send((Response.CompleteListener)new Response.Listener.Adapter(){
            private volatile boolean committed;

            public void onHeaders(final Response response) {
                LOG.debug("onHeaders called with response: {}. Sending replyInfo to client.", new Object[]{response});
                Fields responseHeaders = HTTPProxyEngine.this.createResponseHeaders(clientStream, response);
                HTTPProxyEngine.this.removeHopHeaders(responseHeaders);
                ReplyInfo replyInfo = new ReplyInfo(responseHeaders, false);
                clientStream.reply(replyInfo, (Callback)new Callback.Adapter(){

                    public void failed(Throwable x) {
                        LOG.debug("failed: ", x);
                        response.abort(x);
                    }

                    public void succeeded() {
                        committed = true;
                    }
                });
            }

            public void onContent(final Response response, ByteBuffer content) {
                LOG.debug("onContent called with response: {} and content: {}. Sending response content to client.", new Object[]{response, content});
                final ByteBuffer contentCopy = HTTPProxyEngine.this.httpClient.getByteBufferPool().acquire(content.remaining(), true);
                BufferUtil.flipPutFlip((ByteBuffer)content, (ByteBuffer)contentCopy);
                ByteBufferDataInfo dataInfo = new ByteBufferDataInfo(contentCopy, false);
                clientStream.data((DataInfo)dataInfo, new Callback(){

                    public void failed(Throwable x) {
                        LOG.debug("failed: ", x);
                        this.releaseBuffer();
                        response.abort(x);
                    }

                    public void succeeded() {
                        this.releaseBuffer();
                    }

                    private void releaseBuffer() {
                        HTTPProxyEngine.this.httpClient.getByteBufferPool().release(contentCopy);
                    }
                });
            }

            public void onSuccess(Response response) {
                LOG.debug("onSuccess called. Closing client stream.", new Object[0]);
                clientStream.data((DataInfo)new ByteBufferDataInfo(BufferUtil.EMPTY_BUFFER, true), LOGGING_CALLBACK);
            }

            public void onFailure(Response response, Throwable failure) {
                LOG.debug("onFailure called: ", failure);
                if (this.committed) {
                    LOG.debug("clientStream already committed. Resetting stream.", new Object[0]);
                    try {
                        clientStream.getSession().rst(new RstInfo(clientStream.getId(), StreamStatus.INTERNAL_ERROR));
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOG.debug((Throwable)e);
                    }
                } else {
                    if (clientStream.isClosed()) {
                        return;
                    }
                    Fields responseHeaders = HTTPProxyEngine.this.createResponseHeaders(clientStream, response);
                    if (failure instanceof TimeoutException) {
                        responseHeaders.add(HTTPSPDYHeader.STATUS.name(clientStream.getSession().getVersion()), String.valueOf(504));
                    } else {
                        responseHeaders.add(HTTPSPDYHeader.STATUS.name(clientStream.getSession().getVersion()), String.valueOf(502));
                    }
                    ReplyInfo replyInfo = new ReplyInfo(responseHeaders, true);
                    clientStream.reply(replyInfo, LOGGING_CALLBACK);
                }
            }
        });
    }

    private Fields createResponseHeaders(Stream clientStream, Response response) {
        Fields responseHeaders = new Fields();
        for (HttpField header : response.getHeaders()) {
            responseHeaders.add(header.getName(), header.getValue());
        }
        short version = clientStream.getSession().getVersion();
        if (response.getStatus() > 0) {
            responseHeaders.add(HTTPSPDYHeader.STATUS.name(version), String.valueOf(response.getStatus()));
        }
        responseHeaders.add(HTTPSPDYHeader.VERSION.name(version), HttpVersion.HTTP_1_1.asString());
        this.addResponseProxyHeaders(clientStream, responseHeaders);
        return responseHeaders;
    }

    private void addNonSpdyHeadersToRequest(short version, Fields headers, Request request) {
        for (Fields.Field header : headers) {
            if (HTTPSPDYHeader.from((short)version, (String)header.name()) != null) continue;
            request.header(header.name(), header.value());
        }
    }

    static class LoggingCallback
    extends Callback.Adapter {
        LoggingCallback() {
        }

        public void failed(Throwable x) {
            LOG.debug(x);
        }

        public void succeeded() {
            LOG.debug("succeeded", new Object[0]);
        }
    }
}

