/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.Promise;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.client.FlowControlStrategyFactory;
import org.eclipse.jetty.spdy.client.NextProtoNegoClientConnection;
import org.eclipse.jetty.spdy.client.SPDYClientConnectionFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;

public class SPDYClient {
    private final SPDYClientConnectionFactory connectionFactory = new SPDYClientConnectionFactory();
    final short version;
    final Factory factory;
    private volatile SocketAddress bindAddress;
    private volatile long idleTimeout = -1L;
    private volatile int initialWindowSize;

    protected SPDYClient(short version, Factory factory) {
        this.version = version;
        this.factory = factory;
        this.setInitialWindowSize(65536);
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public Future<Session> connect(InetSocketAddress address, SessionFrameListener listener) throws IOException {
        if (!this.factory.isStarted()) {
            throw new IllegalStateException(Factory.class.getSimpleName() + " is not started");
        }
        SocketChannel channel = SocketChannel.open();
        if (this.bindAddress != null) {
            channel.bind(this.bindAddress);
        }
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
        SessionPromise result = new SessionPromise(channel, this, listener);
        channel.connect(address);
        this.factory.selector.connect(channel, (Object)result);
        return result;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    protected String selectProtocol(List<String> serverProtocols) {
        String protocol = "spdy/" + this.version;
        for (String serverProtocol : serverProtocols) {
            if (!serverProtocol.equals(protocol)) continue;
            return protocol;
        }
        return null;
    }

    public SPDYClientConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected SSLEngine newSSLEngine(SslContextFactory sslContextFactory, SocketChannel channel) {
        String peerHost = channel.socket().getInetAddress().getHostAddress();
        int peerPort = channel.socket().getPort();
        SSLEngine engine = sslContextFactory.newSSLEngine(peerHost, peerPort);
        engine.setUseClientMode(true);
        return engine;
    }

    protected FlowControlStrategy newFlowControlStrategy() {
        return FlowControlStrategyFactory.newFlowControlStrategy(this.version);
    }

    public void replaceConnection(EndPoint endPoint, Connection connection) {
        endPoint.getConnection().onClose();
        endPoint.setConnection(connection);
        connection.onOpen();
    }

    static class SessionPromise
    extends Promise<Session> {
        private final SocketChannel channel;
        final SPDYClient client;
        final SessionFrameListener listener;

        private SessionPromise(SocketChannel channel, SPDYClient client, SessionFrameListener listener) {
            this.channel = channel;
            this.client = client;
            this.listener = listener;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                super.cancel(mayInterruptIfRunning);
                this.channel.close();
                return true;
            }
            catch (IOException x) {
                return true;
            }
        }
    }

    public static class Factory
    extends ContainerLifeCycle {
        private final Queue<Session> sessions = new ConcurrentLinkedQueue<Session>();
        final ByteBufferPool bufferPool = new MappedByteBufferPool();
        final Scheduler scheduler = new TimerScheduler();
        final Executor executor;
        private final SslContextFactory sslContextFactory;
        private final SelectorManager selector;
        private final long idleTimeout;

        public Factory() {
            this(null, null);
        }

        public Factory(SslContextFactory sslContextFactory) {
            this(null, sslContextFactory);
        }

        public Factory(Executor executor) {
            this(executor, null);
        }

        public Factory(Executor executor, SslContextFactory sslContextFactory) {
            this(executor, sslContextFactory, 30000L);
        }

        public Factory(Executor executor, SslContextFactory sslContextFactory, long idleTimeout) {
            this.addBean(this.scheduler);
            this.idleTimeout = idleTimeout;
            if (executor == null) {
                executor = new QueuedThreadPool();
            }
            this.executor = executor;
            this.addBean(executor);
            this.sslContextFactory = sslContextFactory;
            if (sslContextFactory != null) {
                this.addBean(sslContextFactory);
            }
            this.selector = new ClientSelectorManager();
            this.addBean(this.selector);
        }

        public SPDYClient newSPDYClient(short version) {
            return new SPDYClient(version, this);
        }

        protected void doStop() throws Exception {
            this.closeConnections();
            super.doStop();
        }

        boolean sessionOpened(Session session) {
            return this.isRunning() && this.sessions.offer(session);
        }

        boolean sessionClosed(Session session) {
            return this.isRunning() && this.sessions.remove(session);
        }

        private void closeConnections() {
            for (Session session : this.sessions) {
                session.goAway();
            }
            this.sessions.clear();
        }

        public Collection<Session> getSessions() {
            return Collections.unmodifiableCollection(this.sessions);
        }

        private class ClientSelectorManager
        extends SelectorManager {
            private ClientSelectorManager() {
            }

            protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selectSet, SelectionKey key) throws IOException {
                SessionPromise attachment = (SessionPromise)((Object)key.attachment());
                long clientIdleTimeout = attachment.client.getIdleTimeout();
                if (clientIdleTimeout < 0L) {
                    clientIdleTimeout = Factory.this.idleTimeout;
                }
                return new SelectChannelEndPoint(channel, selectSet, key, Factory.this.scheduler, clientIdleTimeout);
            }

            protected void execute(Runnable task) {
                Factory.this.executor.execute(task);
            }

            public Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) {
                SessionPromise sessionPromise = (SessionPromise)((Object)attachment);
                SPDYClient client = sessionPromise.client;
                try {
                    if (Factory.this.sslContextFactory != null) {
                        SSLEngine engine = client.newSSLEngine(Factory.this.sslContextFactory, channel);
                        SslConnection sslConnection = new SslConnection(Factory.this.bufferPool, Factory.this.executor, endPoint, engine);
                        SslConnection.DecryptedEndPoint sslEndPoint = sslConnection.getDecryptedEndPoint();
                        NextProtoNegoClientConnection connection = new NextProtoNegoClientConnection(channel, sslEndPoint, attachment, client.factory.executor, client);
                        sslEndPoint.setConnection((Connection)connection);
                        return sslConnection;
                    }
                    SPDYClientConnectionFactory connectionFactory = new SPDYClientConnectionFactory();
                    return connectionFactory.newConnection(channel, endPoint, attachment);
                }
                catch (RuntimeException x) {
                    sessionPromise.failed(null, x);
                    throw x;
                }
            }
        }
    }
}

