/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.server.ServerQuicConfiguration;
import org.eclipse.jetty.quic.server.ServerQuicConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicServerConnectionFactory
extends AbstractConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(QuicServerConnectionFactory.class);
    private final ServerQuicConfiguration quicConfiguration;

    public QuicServerConnectionFactory(ServerQuicConfiguration quicConfiguration) {
        super("quic");
        this.quicConfiguration = quicConfiguration;
    }

    public ServerQuicConfiguration getQuicConfiguration() {
        return this.quicConfiguration;
    }

    public int getInputBufferSize() {
        return this.quicConfiguration.getInputBufferSize();
    }

    public void setInputBufferSize(int size) {
        this.quicConfiguration.setInputBufferSize(size);
    }

    protected void doStart() throws Exception {
        LOG.info("HTTP/3+QUIC support is experimental and not suited for production use.");
        this.addBean((Object)this.quicConfiguration);
        super.doStart();
    }

    public ServerQuicConnection newConnection(Connector connector, EndPoint endPoint) {
        ServerQuicConnection connection = new ServerQuicConnection(connector, this.quicConfiguration, endPoint);
        connection = (ServerQuicConnection)this.configure((AbstractConnection)connection, connector, endPoint);
        connection.setOutputBufferSize(this.quicConfiguration.getOutputBufferSize());
        connection.setUseInputDirectByteBuffers(this.quicConfiguration.isUseInputDirectByteBuffers());
        connection.setUseOutputDirectByteBuffers(this.quicConfiguration.isUseOutputDirectByteBuffers());
        return connection;
    }
}

