/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.DatagramChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.quic.client.ClientQuicConfiguration;
import org.eclipse.jetty.quic.client.ClientQuicConnection;
import org.eclipse.jetty.quic.client.QuicTransport;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@Deprecated(since="12.0.7", forRemoval=true)
public class QuicClientConnectorConfigurator
extends ClientConnector.Configurator {
    private final QuicConfiguration initQuicConfig = new QuicConfiguration();
    private final UnaryOperator<Connection> configurator;
    private ClientQuicConfiguration quicConfig;

    public QuicClientConnectorConfigurator() {
        this(UnaryOperator.identity());
    }

    public QuicClientConnectorConfigurator(UnaryOperator<Connection> configurator) {
        this.configurator = Objects.requireNonNull(configurator);
        this.initQuicConfig.setSessionRecvWindow(0x1000000);
        this.initQuicConfig.setBidirectionalStreamRecvWindow(0x800000);
        this.initQuicConfig.setDisableActiveMigration(true);
    }

    public QuicConfiguration getQuicConfiguration() {
        if (!this.isStarted()) {
            return this.initQuicConfig;
        }
        return this.quicConfig;
    }

    protected void doStart() throws Exception {
        ClientConnector clientConnector = (ClientConnector)this.getBean(ClientConnector.class);
        SslContextFactory.Client sslContextFactory = clientConnector.getSslContextFactory();
        this.quicConfig = new ClientQuicConfiguration(sslContextFactory, this.initQuicConfig.getPemWorkDirectory());
        this.addBean((Object)this.quicConfig);
        this.quicConfig.setInputBufferSize(this.initQuicConfig.getInputBufferSize());
        this.quicConfig.setOutputBufferSize(this.initQuicConfig.getOutputBufferSize());
        this.quicConfig.setUseInputDirectByteBuffers(this.initQuicConfig.isUseInputDirectByteBuffers());
        this.quicConfig.setUseOutputDirectByteBuffers(this.initQuicConfig.isUseOutputDirectByteBuffers());
        this.quicConfig.setProtocols(this.initQuicConfig.getProtocols());
        this.quicConfig.setDisableActiveMigration(this.initQuicConfig.isDisableActiveMigration());
        this.quicConfig.setMaxBidirectionalRemoteStreams(this.initQuicConfig.getMaxBidirectionalRemoteStreams());
        this.quicConfig.setMaxUnidirectionalRemoteStreams(this.initQuicConfig.getMaxUnidirectionalRemoteStreams());
        this.quicConfig.setSessionRecvWindow(this.initQuicConfig.getSessionRecvWindow());
        this.quicConfig.setBidirectionalStreamRecvWindow(this.initQuicConfig.getBidirectionalStreamRecvWindow());
        this.quicConfig.setUnidirectionalStreamRecvWindow(this.initQuicConfig.getUnidirectionalStreamRecvWindow());
        this.quicConfig.getImplementationConfiguration().putAll(this.initQuicConfig.getImplementationConfiguration());
        super.doStart();
    }

    public Transport newTransport() {
        return new QuicTransport(this.quicConfig);
    }

    public boolean isIntrinsicallySecure(ClientConnector clientConnector, SocketAddress address) {
        return true;
    }

    public ClientConnector.Configurator.ChannelWithAddress newChannelWithAddress(ClientConnector clientConnector, SocketAddress address, Map<String, Object> context) throws IOException {
        context.put(QuicConfiguration.CONTEXT_KEY, this.initQuicConfig);
        DatagramChannel channel = DatagramChannel.open();
        if (clientConnector.getBindAddress() == null) {
            channel.bind(null);
        }
        return new ClientConnector.Configurator.ChannelWithAddress((SelectableChannel)channel, address);
    }

    public EndPoint newEndPoint(ClientConnector clientConnector, SocketAddress address, SelectableChannel selectable, ManagedSelector selector, SelectionKey selectionKey) {
        return new DatagramChannelEndPoint((DatagramChannel)selectable, selector, selectionKey, clientConnector.getScheduler());
    }

    public Connection newConnection(ClientConnector clientConnector, SocketAddress address, EndPoint endPoint, Map<String, Object> context) {
        return (Connection)this.configurator.apply((Connection)new ClientQuicConnection(clientConnector, endPoint, context));
    }
}

