/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.quic.client.ClientQuicSession;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.common.QuicConnection;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientQuicConnection
extends QuicConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ClientQuicConnection.class);
    private final ClientConnector connector;
    private final Map<String, Object> context;
    private final InetSocketAddress inetLocalAddress;
    private Scheduler.Task connectTask;
    private ClientQuicSession pendingSession;
    private InetSocketAddress inetRemoteAddress;

    public ClientQuicConnection(ClientConnector connector, EndPoint endPoint, Map<String, Object> context) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), endPoint);
        InetSocketAddress inet;
        this.connector = connector;
        this.context = context;
        SocketAddress socketAddress = this.getEndPoint().getLocalSocketAddress();
        this.inetLocalAddress = socketAddress instanceof InetSocketAddress ? (inet = (InetSocketAddress)socketAddress) : new InetSocketAddress(InetAddress.getLoopbackAddress(), 64147);
    }

    public void onOpen() {
        try {
            ClientQuicSession session;
            InetSocketAddress inet;
            Path certificatesPath;
            Path privateKeyPath;
            super.onOpen();
            QuicConfiguration quicConfiguration = (QuicConfiguration)this.context.get(QuicConfiguration.CONTEXT_KEY);
            List protocols = quicConfiguration.getProtocols();
            if ((protocols == null || protocols.isEmpty()) && ((protocols = (List)this.context.get("org.eclipse.jetty.client.connector.applicationProtocols")) == null || protocols.isEmpty())) {
                throw new IllegalStateException("Missing ALPN protocols");
            }
            QuicheConfig quicheConfig = new QuicheConfig();
            quicheConfig.setApplicationProtos((String[])protocols.toArray(String[]::new));
            quicheConfig.setDisableActiveMigration(Boolean.valueOf(quicConfiguration.isDisableActiveMigration()));
            quicheConfig.setVerifyPeer(Boolean.valueOf(!this.connector.getSslContextFactory().isTrustAll()));
            Map implCtx = quicConfiguration.getImplementationConfiguration();
            Path trustedCertificatesPath = (Path)implCtx.get(QuicConfiguration.TRUSTED_CERTIFICATES_PEM_PATH_KEY);
            if (trustedCertificatesPath != null) {
                quicheConfig.setTrustedCertsPemPath(trustedCertificatesPath.toString());
            }
            if ((privateKeyPath = (Path)implCtx.get(QuicConfiguration.PRIVATE_KEY_PEM_PATH_KEY)) != null) {
                quicheConfig.setPrivKeyPemPath(privateKeyPath.toString());
            }
            if ((certificatesPath = (Path)implCtx.get(QuicConfiguration.CERTIFICATE_CHAIN_PEM_PATH_KEY)) != null) {
                quicheConfig.setCertChainPemPath(certificatesPath.toString());
            }
            quicheConfig.setMaxIdleTimeout(Long.valueOf(0L));
            quicheConfig.setInitialMaxData(Long.valueOf(quicConfiguration.getSessionRecvWindow()));
            quicheConfig.setInitialMaxStreamDataBidiLocal(Long.valueOf(quicConfiguration.getBidirectionalStreamRecvWindow()));
            quicheConfig.setInitialMaxStreamDataBidiRemote(Long.valueOf(quicConfiguration.getBidirectionalStreamRecvWindow()));
            quicheConfig.setInitialMaxStreamDataUni(Long.valueOf(quicConfiguration.getUnidirectionalStreamRecvWindow()));
            quicheConfig.setInitialMaxStreamsUni(Long.valueOf(quicConfiguration.getMaxUnidirectionalRemoteStreams()));
            quicheConfig.setInitialMaxStreamsBidi(Long.valueOf(quicConfiguration.getMaxBidirectionalRemoteStreams()));
            quicheConfig.setCongestionControl(QuicheConfig.CongestionControl.CUBIC);
            SocketAddress remoteAddress = (SocketAddress)this.context.get("org.eclipse.jetty.client.connector.remoteSocketAddress");
            InetSocketAddress inetSocketAddress = this.inetRemoteAddress = remoteAddress instanceof InetSocketAddress ? (inet = (InetSocketAddress)remoteAddress) : new InetSocketAddress(InetAddress.getLoopbackAddress(), 443);
            if (LOG.isDebugEnabled()) {
                LOG.debug("connecting to {} with protocols {}", (Object)remoteAddress, (Object)protocols);
            }
            QuicheConnection quicheConnection = QuicheConnection.connect((QuicheConfig)quicheConfig, (InetSocketAddress)this.inetLocalAddress, (InetSocketAddress)this.inetRemoteAddress);
            this.pendingSession = session = new ClientQuicSession(this.getExecutor(), this.getScheduler(), this.getByteBufferPool(), quicheConnection, this, this.inetRemoteAddress, this.context);
            if (LOG.isDebugEnabled()) {
                LOG.debug("created {}", (Object)session);
            }
            this.connectTask = this.getScheduler().schedule(() -> this.connectTimeout(remoteAddress), this.connector.getConnectTimeout().toMillis(), TimeUnit.MILLISECONDS);
            session.flush();
            this.fillInterested();
        }
        catch (IOException x) {
            throw new RuntimeIOException((Throwable)x);
        }
    }

    public void onFillable() {
        this.connectTask.cancel();
        super.onFillable();
    }

    private void connectTimeout(SocketAddress remoteAddress) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect timeout {} ms to {} on {}", new Object[]{this.connector.getConnectTimeout(), remoteAddress, this});
        }
        this.close();
        this.outwardClose(new SocketTimeoutException("connect timeout"));
    }

    protected QuicSession createSession(SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        InetSocketAddress inet;
        InetSocketAddress inetRemote = remoteAddress instanceof InetSocketAddress ? (inet = (InetSocketAddress)remoteAddress) : this.inetRemoteAddress;
        Runnable task = this.pendingSession.process(inetRemote, cipherBuffer);
        this.pendingSession.offerTask(task);
        if (this.pendingSession.isConnectionEstablished()) {
            ClientQuicSession session = this.pendingSession;
            this.pendingSession = null;
            return session;
        }
        return null;
    }

    public InetSocketAddress getLocalInetSocketAddress() {
        return this.inetLocalAddress;
    }

    protected Runnable process(QuicSession session, SocketAddress remoteAddress, ByteBuffer cipherBuffer) {
        InetSocketAddress inet;
        InetSocketAddress inetRemote = remoteAddress instanceof InetSocketAddress ? (inet = (InetSocketAddress)remoteAddress) : this.inetRemoteAddress;
        return super.process(session, (SocketAddress)inetRemote, cipherBuffer);
    }

    protected void onFailure(Throwable failure) {
        this.outwardClose(this.pendingSession, failure);
        super.onFailure(failure);
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        boolean idle = this.isFillInterested();
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} elapsed idle timeout {} ms", (Object)(idle ? "processing" : "ignoring"), (Object)idleTimeout);
        }
        if (idle) {
            Collection sessions = this.getQuicSessions();
            sessions.forEach(QuicSession::onIdleTimeout);
        }
        return false;
    }

    public void outwardClose(QuicSession session, Throwable failure) {
        super.outwardClose(session, failure);
        this.outwardClose(failure);
    }

    private void outwardClose(Throwable failure) {
        this.pendingSession = null;
        Promise promise = (Promise)this.context.get("org.eclipse.jetty.client.connector.connectionPromise");
        if (promise != null) {
            promise.failed(failure);
        }
        this.getEndPoint().close(failure);
    }
}

