/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.api.frames;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongFunction;
import org.eclipse.jetty.util.TypeUtil;

public class TransportParameters
implements Iterable<Map.Entry<Id<?>, Object>> {
    private final Map<Id<?>, Object> parameters = new HashMap();

    @Override
    public Iterator<Map.Entry<Id<?>, Object>> iterator() {
        return this.parameters.entrySet().iterator();
    }

    public <T> T get(Id<T> id) {
        Object value = this.parameters.get(id);
        return (T)value;
    }

    public <T> T put(Id<T> id, T value) {
        return (T)this.parameters.put(id, value);
    }

    public <T> T putIfAbsent(Id<T> id, T value) {
        return (T)this.parameters.putIfAbsent(id, value);
    }

    public void putGreaseParameter() {
        long id = Ids.newGrease();
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        this.put(Ids.create(id, BytesId::new), bytes);
    }

    public int size() {
        return this.parameters.size();
    }

    public String toString() {
        return "%s@%x[%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.parameters);
    }

    public static class Ids {
        private static final long MAX_N = 148764065110560899L;
        private static final Map<Long, Id<?>> ids = new HashMap();
        public static final Id<Long> MAX_IDLE_TIMEOUT = Ids.create(1L, LongId::new);
        public static final Id<Long> INITIAL_MAX_DATA = Ids.create(4L, LongId::new);
        public static final Id<Long> INITIAL_MAX_STREAM_DATA_BIDIRECTIONAL_LOCAL = Ids.create(5L, LongId::new);
        public static final Id<Long> INITIAL_MAX_STREAM_DATA_BIDIRECTIONAL_REMOTE = Ids.create(6L, LongId::new);
        public static final Id<Long> INITIAL_MAX_STREAM_DATA_UNIDIRECTIONAL = Ids.create(7L, LongId::new);
        public static final Id<Long> INITIAL_MAX_STREAMS_BIDIRECTIONAL = Ids.create(8L, LongId::new);
        public static final Id<Long> INITIAL_MAX_STREAMS_UNIDIRECTIONAL = Ids.create(9L, LongId::new);

        public static <R> Id<R> create(long id, LongFunction<Id<R>> creator) {
            return ids.computeIfAbsent(id, creator::apply);
        }

        public static <R> Id<R> get(long id) {
            return ids.get(id);
        }

        public static long newGrease() {
            return 31L * ThreadLocalRandom.current().nextLong(148764065110560900L) + 27L;
        }

        public static boolean isGrease(long id) {
            return (id - 27L) % 31L == 0L;
        }
    }

    public static abstract class Id<T> {
        private final long id;

        protected Id(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public int hashCode() {
            return Long.hashCode(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Id) {
                Id that = (Id)obj;
                return this.id == that.id;
            }
            return false;
        }

        public String toString() {
            return "%s[%d]".formatted(TypeUtil.toShortName(this.getClass()), this.id);
        }
    }

    public static class BytesId
    extends Id<byte[]> {
        public BytesId(long id) {
            super(id);
        }
    }

    public static class LongId
    extends Id<Long> {
        public LongId(long id) {
            super(id);
        }
    }
}

