/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.api.frames;

import java.util.List;
import org.eclipse.jetty.quic.api.frames.Frame;

public class AckFrame
extends Frame {
    private final long ackNumber;
    private final long ackDelay;
    private final List<Integer> ranges;
    private final long ect0Count;
    private final long ect1Count;
    private final long ceCount;

    public AckFrame(long ackNumber, long ackDelay, List<Integer> ranges) {
        this(2, ackNumber, ackDelay, ranges, 0, 0, 0);
    }

    public AckFrame(long ackNumber, long ackDelay, List<Integer> ranges, int ect0Count, int ect1Count, int ceCount) {
        this(3, ackNumber, ackDelay, ranges, ect0Count, ect1Count, ceCount);
    }

    private AckFrame(int type, long ackNumber, long ackDelay, List<Integer> ranges, int ect0Count, int ect1Count, int ceCount) {
        super(type);
        this.ackNumber = ackNumber;
        this.ackDelay = ackDelay;
        if (ranges.size() < 1) {
            throw new IllegalArgumentException("invalid_range_list");
        }
        this.ranges = ranges;
        this.ect0Count = ect0Count;
        this.ect1Count = ect1Count;
        this.ceCount = ceCount;
    }

    public long getAckNumber() {
        return this.ackNumber;
    }

    public long getAckDelay() {
        return this.ackDelay;
    }

    public List<Integer> getRanges() {
        return this.ranges;
    }

    public long getECT0Count() {
        return this.ect0Count;
    }

    public long getECT1Count() {
        return this.ect1Count;
    }

    public long getCECount() {
        return this.ceCount;
    }
}

