/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.OSGiAppProvider;
import org.eclipse.jetty.osgi.boot.internal.jsp.TldLocatableURLClassloader;
import org.eclipse.jetty.osgi.boot.internal.webapp.LibExtClassLoaderHelper;
import org.eclipse.jetty.osgi.boot.internal.webapp.WebBundleDeployerHelper;
import org.eclipse.jetty.osgi.boot.utils.WebappRegistrationCustomizer;
import org.eclipse.jetty.osgi.boot.utils.internal.DefaultFileLocatorHelper;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.xml.sax.SAXParseException;

public class ServerInstanceWrapper {
    public static final String PROPERTY_THIS_JETTY_XML_FOLDER_URL = "this.jetty.xml.parent.folder.url";
    private static Logger __logger = Log.getLogger((String)ServerInstanceWrapper.class.getName());
    private final String _managedServerName;
    private Server _server;
    private ContextHandlerCollection _ctxtHandler;
    private ClassLoader _commonParentClassLoaderForWebapps;
    private DeploymentManager _deploymentManager;
    private OSGiAppProvider _provider;
    private WebBundleDeployerHelper _webBundleDeployerHelper;

    public ServerInstanceWrapper(String managedServerName) {
        this._managedServerName = managedServerName;
    }

    public String getManagedServerName() {
        return this._managedServerName;
    }

    public ClassLoader getParentClassLoaderForWebapps() {
        return this._commonParentClassLoaderForWebapps;
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public OSGiAppProvider getOSGiAppProvider() {
        return this._provider;
    }

    public Server getServer() {
        return this._server;
    }

    public WebBundleDeployerHelper getWebBundleDeployerHelp() {
        return this._webBundleDeployerHelper;
    }

    public ContextHandlerCollection getContextHandlerCollection() {
        return this._ctxtHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Server server, Dictionary props) {
        this._server = server;
        ClassLoader contextCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader libExtClassLoader = null;
            String sharedURLs = (String)props.get("managedJettySharedLibFolderUrls");
            try {
                List<File> shared = sharedURLs != null ? this.extractFiles(sharedURLs) : null;
                libExtClassLoader = LibExtClassLoaderHelper.createLibExtClassLoader(shared, null, server, JettyBootstrapActivator.class.getClassLoader());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            Thread.currentThread().setContextClassLoader(libExtClassLoader);
            this.configure(server, props);
            this.init();
            try {
                URL[] jarsWithTlds = this.getJarsWithTlds();
                this._commonParentClassLoaderForWebapps = jarsWithTlds == null ? libExtClassLoader : new TldLocatableURLClassloader(libExtClassLoader, jarsWithTlds);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            server.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCl);
        }
        this._webBundleDeployerHelper = new WebBundleDeployerHelper(this);
    }

    public void stop() {
        try {
            if (this._server.isRunning()) {
                this._server.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URL[] getJarsWithTlds() throws Exception {
        ArrayList<URL> res = new ArrayList<URL>();
        WebBundleDeployerHelper.staticInit();
        for (WebappRegistrationCustomizer regCustomizer : WebBundleDeployerHelper.JSP_REGISTRATION_HELPERS) {
            URL[] urls;
            for (URL url : urls = regCustomizer.getJarsWithTlds(this._provider, WebBundleDeployerHelper.BUNDLE_FILE_LOCATOR_HELPER)) {
                if (res.contains(url)) continue;
                res.add(url);
            }
        }
        if (!res.isEmpty()) {
            return res.toArray(new URL[res.size()]);
        }
        return null;
    }

    private void configure(Server server, Dictionary props) throws Exception {
        List<URL> jettyConfigurations;
        String jettyConfigurationUrls = (String)props.get("jetty.etc.config.urls");
        List<URL> list = jettyConfigurations = jettyConfigurationUrls != null ? this.extractResources(jettyConfigurationUrls) : null;
        if (jettyConfigurations == null || jettyConfigurations.isEmpty()) {
            return;
        }
        Map<String, Object> id_map = new HashMap<String, Server>();
        id_map.put("Server", server);
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration en = props.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object value = props.get(key);
            properties.put(String.valueOf(key), String.valueOf(value));
        }
        for (URL jettyConfiguration : jettyConfigurations) {
            InputStream is = null;
            try {
                Resource r = Resource.newResource((URL)jettyConfiguration);
                is = r.getInputStream();
                XmlConfiguration config = new XmlConfiguration(is);
                config.getIdMap().putAll(id_map);
                String urlPath = jettyConfiguration.toString();
                int lastSlash = urlPath.lastIndexOf(47);
                if (lastSlash > 4) {
                    urlPath = urlPath.substring(0, lastSlash);
                    HashMap<String, String> properties2 = new HashMap<String, String>(properties);
                    properties2.put(PROPERTY_THIS_JETTY_XML_FOLDER_URL, urlPath);
                    config.getProperties().putAll(properties2);
                } else {
                    config.getProperties().putAll(properties);
                }
                config.configure();
                id_map = config.getIdMap();
            }
            catch (SAXParseException saxparse) {
                try {
                    __logger.warn("Unable to configure the jetty/etc file " + jettyConfiguration, (Throwable)saxparse);
                    throw saxparse;
                }
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
            }
            IO.close((InputStream)is);
        }
    }

    private void init() {
        this._ctxtHandler = (ContextHandlerCollection)this._server.getChildHandlerByClass(ContextHandlerCollection.class);
        List deployers = this._server.getBeans(DeploymentManager.class);
        if (deployers != null && !deployers.isEmpty()) {
            this._deploymentManager = (DeploymentManager)deployers.get(0);
            for (AppProvider provider : this._deploymentManager.getAppProviders()) {
                if (!(provider instanceof OSGiAppProvider)) continue;
                this._provider = (OSGiAppProvider)provider;
                break;
            }
            if (this._provider == null) {
                try {
                    this._provider = new OSGiAppProvider();
                    this._provider.setMonitoredDirResource(Resource.newResource((URI)this.getDefaultOSGiContextsHome(new File(System.getProperty("jetty.home"))).toURI()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this._deploymentManager.addAppProvider((AppProvider)this._provider);
            }
        }
        if (this._ctxtHandler == null || this._provider == null) {
            throw new IllegalStateException("ERROR: No ContextHandlerCollection or OSGiAppProvider configured");
        }
    }

    File getDefaultOSGiContextsHome(File jettyHome) {
        String jettyContextsHome = System.getProperty("jetty.osgi.contexts.home");
        if (jettyContextsHome != null) {
            File contextsHome = new File(jettyContextsHome);
            if (!contextsHome.exists() || !contextsHome.isDirectory()) {
                throw new IllegalArgumentException("the ${jetty.osgi.contexts.home} '" + jettyContextsHome + " must exist and be a folder");
            }
            return contextsHome;
        }
        return new File(jettyHome, "/contexts");
    }

    File getOSGiContextsHome() {
        return this._provider.getContextXmlDirAsFile();
    }

    private List<URL> extractResources(String propertyValue) {
        StringTokenizer tokenizer = new StringTokenizer(propertyValue, ",;", false);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            try {
                DefaultFileLocatorHelper cfr_ignored_0 = (DefaultFileLocatorHelper)WebBundleDeployerHelper.BUNDLE_FILE_LOCATOR_HELPER;
                urls.add(DefaultFileLocatorHelper.getLocalURL(new URL(tok)));
            }
            catch (Throwable mfe) {}
        }
        return urls;
    }

    private List<File> extractFiles(String propertyValue) {
        StringTokenizer tokenizer = new StringTokenizer(propertyValue, ",;", false);
        ArrayList<File> files = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            try {
                Resource res;
                File folder;
                URL url = new URL(tok);
                DefaultFileLocatorHelper cfr_ignored_0 = (DefaultFileLocatorHelper)WebBundleDeployerHelper.BUNDLE_FILE_LOCATOR_HELPER;
                if (!(url = DefaultFileLocatorHelper.getFileURL(url)).getProtocol().equals("file") || (folder = (res = Resource.newResource((URL)url)).getFile()) == null) continue;
                files.add(folder);
            }
            catch (Throwable mfe) {}
        }
        return files;
    }
}

