/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.osgi.boot.internal.webapp.IWebBundleDeployerHelper;
import org.eclipse.jetty.osgi.boot.internal.webapp.OSGiWebappClassLoader;
import org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelper;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.WebappRegistrationCustomizer;
import org.eclipse.jetty.osgi.boot.utils.internal.DefaultBundleClassLoaderHelper;
import org.eclipse.jetty.osgi.boot.utils.internal.DefaultFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBundleDeployerHelper
implements IWebBundleDeployerHelper {
    private static Logger __logger = Log.getLogger((String)WebBundleDeployerHelper.class.getName());
    private static boolean INITIALIZED = false;
    public static BundleClassLoaderHelper BUNDLE_CLASS_LOADER_HELPER = null;
    public static BundleFileLocatorHelper BUNDLE_FILE_LOCATOR_HELPER = null;
    public static Collection<WebappRegistrationCustomizer> JSP_REGISTRATION_HELPERS = new ArrayList<WebappRegistrationCustomizer>();
    private ServerInstanceWrapper _wrapper;

    public WebBundleDeployerHelper(ServerInstanceWrapper wrapper) {
        WebBundleDeployerHelper.staticInit();
        this._wrapper = wrapper;
    }

    public static synchronized void staticInit() {
        if (!INITIALIZED) {
            INITIALIZED = true;
            try {
                BUNDLE_CLASS_LOADER_HELPER = (BundleClassLoaderHelper)Class.forName("org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelperImpl").newInstance();
            }
            catch (Throwable t) {
                BUNDLE_CLASS_LOADER_HELPER = new DefaultBundleClassLoaderHelper();
            }
            try {
                BUNDLE_FILE_LOCATOR_HELPER = (BundleFileLocatorHelper)Class.forName("org.eclipse.jetty.osgi.boot.utils.FileLocatorHelperImpl").newInstance();
            }
            catch (Throwable t) {
                BUNDLE_FILE_LOCATOR_HELPER = new DefaultFileLocatorHelper();
            }
        }
    }

    @Override
    public WebAppContext registerWebapplication(Bundle bundle, String webappFolderPath, String contextPath, String extraClasspath, String overrideBundleInstallLocation, String requireTldBundle, String webXmlPath, String defaultWebXmlPath, WebAppContext webAppContext) throws Exception {
        File bundleInstall = overrideBundleInstallLocation == null ? BUNDLE_FILE_LOCATOR_HELPER.getBundleInstallLocation(bundle) : new File(overrideBundleInstallLocation);
        File webapp = null;
        URL baseWebappInstallURL = null;
        if (webappFolderPath != null && webappFolderPath.length() != 0 && !webappFolderPath.equals(".")) {
            Enumeration<URL> urls;
            if (webappFolderPath.startsWith("/") || webappFolderPath.startsWith("file:")) {
                webapp = new File(webappFolderPath);
            } else if (bundleInstall != null && bundleInstall.isDirectory()) {
                webapp = new File(bundleInstall, webappFolderPath);
            } else if (bundleInstall != null && (urls = BUNDLE_FILE_LOCATOR_HELPER.findEntries(bundle, webappFolderPath)) != null && urls.hasMoreElements()) {
                baseWebappInstallURL = urls.nextElement();
            }
        } else {
            webapp = bundleInstall;
        }
        if (!(baseWebappInstallURL != null || webapp != null && webapp.exists())) {
            throw new IllegalArgumentException("Unable to locate " + webappFolderPath + " inside " + (bundleInstall != null ? bundleInstall.getAbsolutePath() : "unlocated bundle '" + bundle.getSymbolicName() + "'"));
        }
        if (baseWebappInstallURL == null && webapp != null) {
            baseWebappInstallURL = webapp.toURI().toURL();
        }
        return this.registerWebapplication(bundle, webappFolderPath, baseWebappInstallURL, contextPath, extraClasspath, bundleInstall, requireTldBundle, webXmlPath, defaultWebXmlPath, webAppContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebAppContext registerWebapplication(Bundle contributor, String pathInBundleToWebApp, URL baseWebappInstallURL, String contextPath, String extraClasspath, File bundleInstall, String requireTldBundle, String webXmlPath, String defaultWebXmlPath, WebAppContext context) throws Exception {
        WebAppContext webAppContext;
        ClassLoader contextCl;
        block12: {
            contextCl = Thread.currentThread().getContextClassLoader();
            String[] oldServerClasses = null;
            try {
                OSGiWebappClassLoader composite = this.createWebappClassLoader(contributor);
                Thread.currentThread().setContextClassLoader((ClassLoader)((Object)composite));
                context.setWar(baseWebappInstallURL.toString());
                context.setContextPath(contextPath);
                context.setExtraClasspath(extraClasspath);
                if (webXmlPath != null && webXmlPath.length() != 0) {
                    File webXml = null;
                    webXml = webXmlPath.startsWith("/") || webXmlPath.startsWith("file:/") ? new File(webXmlPath) : new File(bundleInstall, webXmlPath);
                    if (webXml.exists()) {
                        context.setDescriptor(webXml.getAbsolutePath());
                    }
                }
                if (defaultWebXmlPath == null || defaultWebXmlPath.length() == 0) {
                    defaultWebXmlPath = this._wrapper.getOSGiAppProvider().getDefaultsDescriptor();
                }
                if (defaultWebXmlPath != null && defaultWebXmlPath.length() != 0) {
                    File defaultWebXml = null;
                    defaultWebXml = defaultWebXmlPath.startsWith("/") || defaultWebXmlPath.startsWith("file:/") ? new File(webXmlPath) : new File(bundleInstall, defaultWebXmlPath);
                    if (defaultWebXml.exists()) {
                        context.setDefaultsDescriptor(defaultWebXml.getAbsolutePath());
                    }
                }
                context.setParentLoaderPriority(this._wrapper.getOSGiAppProvider().isParentLoaderPriority());
                this.configureWebAppContext((ContextHandler)context, contributor, requireTldBundle);
                this.configureWebappClassLoader(contributor, (ContextHandler)context, composite);
                oldServerClasses = context.getServerClasses();
                context.setServerClasses(null);
                this._wrapper.getOSGiAppProvider().addContext(contributor, pathInBundleToWebApp, (ContextHandler)context);
                List patchResources = (List)context.getAttribute("org.eclipse.jetty.resources.patch");
                if (patchResources != null) {
                    LinkedList<Resource> resourcesPath = new LinkedList<Resource>();
                    resourcesPath.addAll(patchResources);
                    Resource hostResources = context.getBaseResource();
                    if (hostResources instanceof ResourceCollection) {
                        for (Resource re : ((ResourceCollection)hostResources).getResources()) {
                            resourcesPath.add(re);
                        }
                    } else {
                        resourcesPath.add(hostResources);
                    }
                    ResourceCollection rc = new ResourceCollection(resourcesPath.toArray(new Resource[resourcesPath.size()]));
                    context.setBaseResource((Resource)rc);
                }
                webAppContext = context;
                if (context == null || oldServerClasses == null) break block12;
            }
            catch (Throwable throwable) {
                if (context != null && oldServerClasses != null) {
                    context.setServerClasses(oldServerClasses);
                }
                Thread.currentThread().setContextClassLoader(contextCl);
                throw throwable;
            }
            context.setServerClasses(oldServerClasses);
        }
        Thread.currentThread().setContextClassLoader(contextCl);
        return webAppContext;
    }

    @Override
    public void unregister(ContextHandler contextHandler) throws Exception {
        this._wrapper.getOSGiAppProvider().removeContext(contextHandler);
    }

    @Override
    public ContextHandler registerContext(Bundle contributor, String contextFileRelativePath, String extraClasspath, String overrideBundleInstallLocation, String requireTldBundle, ContextHandler handler) throws Exception {
        URL contextURL;
        File contextFile;
        File prodContextFile;
        File contextsHome = this._wrapper.getOSGiAppProvider().getContextXmlDirAsFile();
        if (contextsHome != null && (prodContextFile = new File(contextsHome, contributor.getSymbolicName() + "/" + contextFileRelativePath)).exists()) {
            return this.registerContext(contributor, contextFileRelativePath, prodContextFile, extraClasspath, overrideBundleInstallLocation, requireTldBundle, handler);
        }
        File rootFolder = overrideBundleInstallLocation != null ? Resource.newResource((String)overrideBundleInstallLocation).getFile() : BUNDLE_FILE_LOCATOR_HELPER.getBundleInstallLocation(contributor);
        File file = contextFile = rootFolder != null ? new File(rootFolder, contextFileRelativePath) : null;
        if (contextFile != null && contextFile.exists()) {
            return this.registerContext(contributor, contextFileRelativePath, contextFile, extraClasspath, overrideBundleInstallLocation, requireTldBundle, handler);
        }
        if (contextFileRelativePath.startsWith("./")) {
            contextFileRelativePath = contextFileRelativePath.substring(1);
        }
        if (!contextFileRelativePath.startsWith("/")) {
            contextFileRelativePath = "/" + contextFileRelativePath;
        }
        if ((contextURL = contributor.getEntry(contextFileRelativePath)) != null) {
            Resource r = Resource.newResource((URL)contextURL);
            return this.registerContext(contributor, contextFileRelativePath, r.getInputStream(), extraClasspath, overrideBundleInstallLocation, requireTldBundle, handler);
        }
        throw new IllegalArgumentException("Could not find the context file " + contextFileRelativePath + " for the bundle " + contributor.getSymbolicName() + (overrideBundleInstallLocation != null ? " using the install location " + overrideBundleInstallLocation : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextHandler registerContext(Bundle contributor, String pathInBundle, File contextFile, String extraClasspath, String overrideBundleInstallLocation, String requireTldBundle, ContextHandler handler) throws Exception {
        ContextHandler contextHandler;
        BufferedInputStream contextFileInputStream = null;
        try {
            contextFileInputStream = new BufferedInputStream(new FileInputStream(contextFile));
            contextHandler = this.registerContext(contributor, pathInBundle, contextFileInputStream, extraClasspath, overrideBundleInstallLocation, requireTldBundle, handler);
        }
        catch (Throwable throwable) {
            IO.close(contextFileInputStream);
            throw throwable;
        }
        IO.close((InputStream)contextFileInputStream);
        return contextHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextHandler registerContext(Bundle contributor, String pathInsideBundle, InputStream contextFileInputStream, String extraClasspath, String overrideBundleInstallLocation, String requireTldBundle, ContextHandler handler) throws Exception {
        ContextHandler contextHandler;
        ClassLoader contextCl;
        block7: {
            ContextHandler context;
            OSGiWebappClassLoader composite;
            WebAppContext webAppContext;
            String[] oldServerClasses;
            block5: {
                ContextHandler contextHandler2;
                block6: {
                    contextCl = Thread.currentThread().getContextClassLoader();
                    oldServerClasses = null;
                    webAppContext = null;
                    try {
                        composite = this.createWebappClassLoader(contributor);
                        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)composite));
                        context = this.createContextHandler(handler, contributor, contextFileInputStream, extraClasspath, overrideBundleInstallLocation, requireTldBundle);
                        if (context != null) break block5;
                        contextHandler2 = null;
                        if (webAppContext == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (webAppContext != null) {
                            webAppContext.setServerClasses(oldServerClasses);
                        }
                        Thread.currentThread().setContextClassLoader(contextCl);
                        throw throwable;
                    }
                    webAppContext.setServerClasses(oldServerClasses);
                }
                Thread.currentThread().setContextClassLoader(contextCl);
                return contextHandler2;
            }
            this.configureWebappClassLoader(contributor, context, composite);
            if (context instanceof WebAppContext) {
                webAppContext = (WebAppContext)context;
                oldServerClasses = webAppContext.getServerClasses();
                webAppContext.setServerClasses(null);
            }
            this._wrapper.getOSGiAppProvider().addContext(contributor, pathInsideBundle, context);
            contextHandler = context;
            if (webAppContext == null) break block7;
            webAppContext.setServerClasses(oldServerClasses);
        }
        Thread.currentThread().setContextClassLoader(contextCl);
        return contextHandler;
    }

    protected void configureWebAppContext(ContextHandler wah, Bundle contributor, String requireTldBundle) throws IOException {
        wah.setAttribute("osgi-bundlecontext", (Object)contributor.getBundleContext());
        wah.setAttribute("org.springframework.osgi.web." + BundleContext.class.getName(), (Object)contributor.getBundleContext());
        wah.setAttribute("osgi-bundle", (Object)contributor);
        wah.setAttribute("Require-TldBundle", (Object)requireTldBundle);
        Bundle[] fragments = PackageAdminServiceTracker.INSTANCE.getFragmentsAndRequiredBundles(contributor);
        if (fragments != null && fragments.length != 0) {
            TreeMap<String, Resource> patchResourcesPath = new TreeMap<String, Resource>();
            TreeMap<String, Resource> appendedResourcesPath = new TreeMap<String, Resource>();
            for (Bundle frag : fragments) {
                String key;
                String fragFolder = (String)frag.getHeaders().get("Jetty-WarFragmentFolderPath");
                String patchFragFolder = (String)frag.getHeaders().get("Jetty-WarPatchFragmentFolderPath");
                if (fragFolder != null) {
                    URL fragUrl = frag.getEntry(fragFolder);
                    if (fragUrl == null) {
                        throw new IllegalArgumentException("Unable to locate " + fragFolder + " inside " + " the fragment '" + frag.getSymbolicName() + "'");
                    }
                    fragUrl = DefaultFileLocatorHelper.getLocalURL(fragUrl);
                    key = fragFolder.startsWith("/") ? fragFolder.substring(1) : fragFolder;
                    appendedResourcesPath.put(key + ";" + frag.getSymbolicName(), Resource.newResource((URL)fragUrl));
                }
                if (patchFragFolder == null) continue;
                URL patchFragUrl = frag.getEntry(patchFragFolder);
                if (patchFragUrl == null) {
                    throw new IllegalArgumentException("Unable to locate " + patchFragUrl + " inside " + " the fragment '" + frag.getSymbolicName() + "'");
                }
                patchFragUrl = DefaultFileLocatorHelper.getLocalURL(patchFragUrl);
                key = patchFragFolder.startsWith("/") ? patchFragFolder.substring(1) : patchFragFolder;
                patchResourcesPath.put(key + ";" + frag.getSymbolicName(), Resource.newResource((URL)patchFragUrl));
            }
            if (!appendedResourcesPath.isEmpty()) {
                wah.setAttribute("org.eclipse.jetty.resources", new ArrayList(appendedResourcesPath.values()));
            }
            if (!patchResourcesPath.isEmpty()) {
                wah.setAttribute("org.eclipse.jetty.resources.patch", new ArrayList(patchResourcesPath.values()));
            }
            if (wah instanceof WebAppContext) {
                WebAppContext webappCtxt = (WebAppContext)wah;
                ArrayList<Resource> frags = (ArrayList<Resource>)wah.getAttribute("org.eclipse.jetty.webFragments");
                ArrayList<Resource> resfrags = (ArrayList<Resource>)wah.getAttribute("org.eclipse.jetty.resources");
                ArrayList<Resource> tldfrags = (ArrayList<Resource>)wah.getAttribute("org.eclipse.jetty.tlds");
                for (Bundle frag : fragments) {
                    URL webFrag = frag.getEntry("/META-INF/web-fragment.xml");
                    Enumeration resEnum = frag.findEntries("/META-INF/resources", "*", true);
                    Enumeration tldEnum = frag.findEntries("/META-INF", "*.tld", false);
                    if (webFrag == null && (resEnum == null || !resEnum.hasMoreElements()) && (tldEnum == null || !tldEnum.hasMoreElements())) continue;
                    try {
                        URL resourcesEntry;
                        File fragFile = BUNDLE_FILE_LOCATOR_HELPER.getBundleInstallLocation(frag);
                        Resource fragFileAsResource = Resource.newResource((URI)fragFile.toURI());
                        webappCtxt.getMetaData().addWebInfJar(fragFileAsResource);
                        if (webFrag != null) {
                            if (frags == null) {
                                frags = new ArrayList<Resource>();
                                wah.setAttribute("org.eclipse.jetty.webFragments", frags);
                            }
                            frags.add(fragFileAsResource);
                        }
                        if (resEnum != null && resEnum.hasMoreElements() && (resourcesEntry = frag.getEntry("/META-INF/resources/")) != null) {
                            if (resfrags == null) {
                                resfrags = new ArrayList<Resource>();
                                wah.setAttribute("org.eclipse.jetty.resources", resfrags);
                            }
                            resfrags.add(Resource.newResource((URL)DefaultFileLocatorHelper.getLocalURL(resourcesEntry)));
                        }
                        if (tldEnum == null || !tldEnum.hasMoreElements()) continue;
                        if (tldfrags == null) {
                            tldfrags = new ArrayList<Resource>();
                            wah.setAttribute("org.eclipse.jetty.tlds", tldfrags);
                        }
                        while (tldEnum.hasMoreElements()) {
                            tldfrags.add(Resource.newResource((URL)DefaultFileLocatorHelper.getLocalURL((URL)tldEnum.nextElement())));
                        }
                    }
                    catch (Exception e) {
                        __logger.warn("Unable to locate the bundle " + frag.getBundleId(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected ContextHandler createContextHandler(ContextHandler handlerToConfigure, Bundle bundle, File contextFile, String extraClasspath, String overrideBundleInstallLocation, String requireTldBundle) {
        try {
            return this.createContextHandler(handlerToConfigure, bundle, new BufferedInputStream(new FileInputStream(contextFile)), extraClasspath, overrideBundleInstallLocation, requireTldBundle);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContextHandler createContextHandler(ContextHandler handlerToConfigure, Bundle bundle, InputStream contextInputStream, String extraClasspath, String overrideBundleInstallLocation, String requireTldBundle) {
        try {
            XmlConfiguration xmlConfiguration = new XmlConfiguration(contextInputStream);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("Server", this._wrapper.getServer());
            this.setThisBundleHomeProperty(bundle, properties, overrideBundleInstallLocation);
            xmlConfiguration.getProperties().putAll(properties);
            ContextHandler context = null;
            if (handlerToConfigure == null) {
                context = (ContextHandler)xmlConfiguration.configure();
            } else {
                xmlConfiguration.configure((Object)handlerToConfigure);
                context = handlerToConfigure;
            }
            if (context instanceof WebAppContext) {
                ((WebAppContext)context).setExtraClasspath(extraClasspath);
                ((WebAppContext)context).setParentLoaderPriority(this._wrapper.getOSGiAppProvider().isParentLoaderPriority());
                if (this._wrapper.getOSGiAppProvider().getDefaultsDescriptor() != null && this._wrapper.getOSGiAppProvider().getDefaultsDescriptor().length() != 0) {
                    ((WebAppContext)context).setDefaultsDescriptor(this._wrapper.getOSGiAppProvider().getDefaultsDescriptor());
                }
            }
            this.configureWebAppContext(context, bundle, requireTldBundle);
            ContextHandler contextHandler = context;
            return contextHandler;
        }
        catch (FileNotFoundException e) {
            ContextHandler contextHandler = null;
            return contextHandler;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            IO.close((InputStream)contextInputStream);
        }
        return null;
    }

    protected void configureWebappClassLoader(Bundle contributor, ContextHandler context, OSGiWebappClassLoader webappClassLoader) throws Exception {
        if (context instanceof WebAppContext) {
            WebAppContext webappCtxt = (WebAppContext)context;
            context.setClassLoader((ClassLoader)((Object)webappClassLoader));
            webappClassLoader.setWebappContext(webappCtxt);
        } else {
            context.setClassLoader((ClassLoader)((Object)webappClassLoader));
        }
    }

    protected OSGiWebappClassLoader createWebappClassLoader(Bundle contributor) throws Exception {
        OSGiWebappClassLoader webappClassLoader = new OSGiWebappClassLoader(this._wrapper.getParentClassLoaderForWebapps(), new WebAppContext(), contributor, BUNDLE_CLASS_LOADER_HELPER);
        return webappClassLoader;
    }

    private void setThisBundleHomeProperty(Bundle bundle, HashMap<String, Object> properties, String overrideBundleInstallLocation) {
        try {
            File location = overrideBundleInstallLocation != null ? new File(overrideBundleInstallLocation) : BUNDLE_FILE_LOCATOR_HELPER.getBundleInstallLocation(bundle);
            properties.put("this.bundle.install", location.getCanonicalPath());
            properties.put("this.bundle.install.url", bundle.getEntry("/").toString());
        }
        catch (Throwable t) {
            __logger.warn("Unable to set 'this.bundle.install'  for the bundle " + bundle.getSymbolicName(), t);
        }
    }
}

