/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.net.URL;
import java.util.Dictionary;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyContextHandlerExtender
implements BundleListener {
    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.register(event.getBundle());
                break;
            }
            case 256: {
                this.unregister(event.getBundle());
            }
        }
    }

    public void init(BundleContext context) {
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if ((bundles[i].getState() & 0x28) == 0) continue;
            this.register(bundles[i]);
        }
    }

    private void register(Bundle bundle) {
        Dictionary dic = bundle.getHeaders();
        String warFolderRelativePath = (String)dic.get("Jetty-WarFolderPath");
        if (warFolderRelativePath != null) {
            String contextPath = (String)dic.get("Web-ContextPath");
            if (contextPath == null || !contextPath.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            try {
                JettyBootstrapActivator.registerWebapplication(bundle, warFolderRelativePath, contextPath);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (dic.get("Jetty-ContextFilePath") != null) {
            String[] pathes;
            String contextFileRelativePath = (String)dic.get("Jetty-ContextFilePath");
            if (contextFileRelativePath == null) {
                return;
            }
            for (String path : pathes = contextFileRelativePath.split(",;")) {
                try {
                    JettyBootstrapActivator.registerContext(bundle, path.trim());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        } else {
            URL rfc66Webxml = bundle.getEntry("/WEB-INF/web.xml");
            if (rfc66Webxml == null) {
                return;
            }
            String rfc66ContextPath = this.getWebContextPath(bundle, dic);
            try {
                JettyBootstrapActivator.registerWebapplication(bundle, ".", rfc66ContextPath);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private String getWebContextPath(Bundle bundle, Dictionary<?, ?> dic) {
        String location;
        String[] toks;
        int lastDot;
        String rfc66ContextPath = (String)dic.get("Web-ContextPath");
        if (rfc66ContextPath == null && (lastDot = (rfc66ContextPath = (toks = (location = bundle.getLocation()).replace('\\', '/').split("/"))[toks.length - 1]).lastIndexOf(46)) != -1) {
            rfc66ContextPath = rfc66ContextPath.substring(0, lastDot);
        }
        if (!rfc66ContextPath.startsWith("/")) {
            rfc66ContextPath = "/" + rfc66ContextPath;
        }
        return rfc66ContextPath;
    }

    private void unregister(Bundle bundle) {
    }
}

