/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelper;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBundleClassLoaderHelper
implements BundleClassLoaderHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BundleClassLoaderHelper.class);
    private static OSGiContainerType osgiContainer;
    private static Class<?> Equinox_BundleHost_Class;
    private static Class<?> Equinox_EquinoxBundle_Class;
    private static Class<?> Felix_BundleImpl_Class;
    private static Class<?> Felix_BundleWiring_Class;
    private static Method Equinox_BundleHost_getBundleLoader_method;
    private static Method Equinox_BundleLoader_createClassLoader_method;
    private static Method Equinox_EquinoxBundle_getModuleClassLoader_Method;
    private static Method Felix_BundleImpl_Adapt_Method;
    private static Field Felix_BundleImpl_m_Modules_Field;
    private static Field Felix_ModuleImpl_m_ClassLoader_Field;
    private static Method Felix_BundleWiring_getClassLoader_Method;
    private static Class<?> Concierge_BundleImpl_Class;
    private static Class<?> Concierge_BundleWiring_Class;
    private static Method Concierge_BundleImpl_Adapt_Method;
    private static Method Concierge_BundleWiring_getClassLoader_Method;

    private static void checkContainerType(Bundle bundle) {
        if (osgiContainer != null) {
            return;
        }
        try {
            Equinox_BundleHost_Class = bundle.getClass().getClassLoader().loadClass("org.eclipse.osgi.framework.internal.core.BundleHost");
            osgiContainer = OSGiContainerType.EquinoxOld;
            return;
        }
        catch (ClassNotFoundException e) {
            LOG.trace("IGNORED", (Throwable)e);
            try {
                Equinox_EquinoxBundle_Class = bundle.getClass().getClassLoader().loadClass("org.eclipse.osgi.internal.framework.EquinoxBundle");
                osgiContainer = OSGiContainerType.EquinoxLuna;
                return;
            }
            catch (ClassNotFoundException e2) {
                LOG.trace("IGNORED", (Throwable)e2);
                try {
                    Felix_BundleImpl_Class = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.BundleImpl");
                    try {
                        Felix_BundleImpl_Adapt_Method = Felix_BundleImpl_Class.getDeclaredMethod("adapt", Class.class);
                        osgiContainer = OSGiContainerType.Felix403;
                        return;
                    }
                    catch (NoSuchMethodException e3) {
                        osgiContainer = OSGiContainerType.FelixOld;
                        return;
                    }
                }
                catch (ClassNotFoundException e4) {
                    LOG.trace("IGNORED", (Throwable)e4);
                    try {
                        Concierge_BundleImpl_Class = bundle.getClass().getClassLoader().loadClass("org.eclipse.concierge.BundleImpl");
                        osgiContainer = OSGiContainerType.Concierge;
                        return;
                    }
                    catch (ClassNotFoundException e5) {
                        LOG.trace("IGNORED", (Throwable)e5);
                        LOG.warn("Unknown OSGi container type");
                        return;
                    }
                }
            }
        }
    }

    @Override
    public ClassLoader getBundleClassLoader(Bundle bundle) {
        String bundleActivator = (String)bundle.getHeaders().get("Bundle-Activator");
        if (bundleActivator == null) {
            bundleActivator = (String)bundle.getHeaders().get("Jetty-ClassInBundle");
        }
        if (bundleActivator != null) {
            try {
                return bundle.loadClass(bundleActivator).getClassLoader();
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Unable to load bundle activator {}", (Object)bundleActivator, (Object)e);
            }
        }
        return this.getBundleClassLoaderForContainer(bundle);
    }

    private ClassLoader getBundleClassLoaderForContainer(Bundle bundle) {
        DefaultBundleClassLoaderHelper.checkContainerType(bundle);
        if (osgiContainer == null) {
            LOG.warn("No classloader for unknown OSGi container type");
            return null;
        }
        switch (osgiContainer) {
            case EquinoxOld: 
            case EquinoxLuna: {
                return DefaultBundleClassLoaderHelper.internalGetEquinoxBundleClassLoader(bundle);
            }
            case FelixOld: 
            case Felix403: {
                return DefaultBundleClassLoaderHelper.internalGetFelixBundleClassLoader(bundle);
            }
            case Concierge: {
                return DefaultBundleClassLoaderHelper.internalGetConciergeBundleClassLoader(bundle);
            }
        }
        LOG.warn("No classloader found for bundle " + bundle.getSymbolicName());
        return null;
    }

    private static ClassLoader internalGetEquinoxBundleClassLoader(Bundle bundle) {
        if (osgiContainer == OSGiContainerType.EquinoxOld) {
            String bundleLoaderName = "org.eclipse.osgi.internal.loader.BundleLoader";
            try {
                if (Equinox_BundleHost_getBundleLoader_method == null) {
                    Equinox_BundleHost_getBundleLoader_method = Equinox_BundleHost_Class.getDeclaredMethod("getBundleLoader", new Class[0]);
                    Equinox_BundleHost_getBundleLoader_method.setAccessible(true);
                }
                Object bundleLoader = Equinox_BundleHost_getBundleLoader_method.invoke((Object)bundle, new Object[0]);
                if (Equinox_BundleLoader_createClassLoader_method == null && bundleLoader != null) {
                    Equinox_BundleLoader_createClassLoader_method = bundleLoader.getClass().getClassLoader().loadClass(bundleLoaderName).getDeclaredMethod("createClassLoader", new Class[0]);
                    Equinox_BundleLoader_createClassLoader_method.setAccessible(true);
                }
                return (ClassLoader)Equinox_BundleLoader_createClassLoader_method.invoke(bundleLoader, new Object[0]);
            }
            catch (Throwable t) {
                LOG.warn("Unable to get equinox bundle classloader", t);
                return null;
            }
        }
        if (osgiContainer == OSGiContainerType.EquinoxLuna) {
            try {
                if (Equinox_EquinoxBundle_getModuleClassLoader_Method == null) {
                    Equinox_EquinoxBundle_getModuleClassLoader_Method = Equinox_EquinoxBundle_Class.getDeclaredMethod("getModuleClassLoader", Boolean.TYPE);
                }
                Equinox_EquinoxBundle_getModuleClassLoader_Method.setAccessible(true);
                return (ClassLoader)Equinox_EquinoxBundle_getModuleClassLoader_Method.invoke((Object)bundle, Boolean.FALSE);
            }
            catch (Exception e) {
                LOG.warn("Unable to get equinox luna bundle classloader", (Throwable)e);
                return null;
            }
        }
        LOG.warn("No classloader for equinox platform for bundle " + bundle.getSymbolicName());
        return null;
    }

    /*
     * Loose catch block
     */
    private static ClassLoader internalGetFelixBundleClassLoader(Bundle bundle) {
        if (osgiContainer == OSGiContainerType.Felix403) {
            try {
                if (Felix_BundleWiring_Class == null) {
                    Felix_BundleWiring_Class = bundle.getClass().getClassLoader().loadClass("org.osgi.framework.wiring.BundleWiring");
                }
                Felix_BundleImpl_Adapt_Method.setAccessible(true);
                if (Felix_BundleWiring_getClassLoader_Method == null) {
                    Felix_BundleWiring_getClassLoader_Method = Felix_BundleWiring_Class.getDeclaredMethod("getClassLoader", new Class[0]);
                    Felix_BundleWiring_getClassLoader_Method.setAccessible(true);
                }
                Object wiring = Felix_BundleImpl_Adapt_Method.invoke((Object)bundle, Felix_BundleWiring_Class);
                return (ClassLoader)Felix_BundleWiring_getClassLoader_Method.invoke(wiring, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Unable to get felix bundle classloader", (Throwable)e);
                return null;
            }
        }
        if (osgiContainer == OSGiContainerType.FelixOld) {
            Object currentModuleImpl;
            if (Felix_BundleImpl_m_Modules_Field == null) {
                Felix_BundleImpl_m_Modules_Field = Felix_BundleImpl_Class.getDeclaredField("m_modules");
                Felix_BundleImpl_m_Modules_Field.setAccessible(true);
            }
            try {
                Object[] moduleArray = (Object[])Felix_BundleImpl_m_Modules_Field.get(bundle);
                currentModuleImpl = moduleArray[moduleArray.length - 1];
            }
            catch (Throwable ex) {
                try {
                    List moduleArray = (List)Felix_BundleImpl_m_Modules_Field.get(bundle);
                    currentModuleImpl = moduleArray.get(moduleArray.size() - 1);
                }
                catch (Exception e) {
                    LOG.warn("Unable to get field {}", (Object)Felix_BundleImpl_m_Modules_Field, (Object)e);
                    return null;
                }
            }
            if (Felix_ModuleImpl_m_ClassLoader_Field == null && currentModuleImpl != null) {
                String felixFrameworkModuleImplClassName = "org.apache.felix.framework.ModuleImpl";
                String felixFrameworkModuleImplClassLoaderField = "m_classLoader";
                try {
                    Felix_ModuleImpl_m_ClassLoader_Field = bundle.getClass().getClassLoader().loadClass(felixFrameworkModuleImplClassName).getDeclaredField(felixFrameworkModuleImplClassLoaderField);
                    Felix_ModuleImpl_m_ClassLoader_Field.setAccessible(true);
                }
                catch (Exception e) {
                    LOG.warn("Unable to find field {}.{}", new Object[]{felixFrameworkModuleImplClassName, felixFrameworkModuleImplClassLoaderField, e});
                    return null;
                }
            }
            ClassLoader cl = null;
            try {
                cl = (ClassLoader)Felix_ModuleImpl_m_ClassLoader_Field.get(currentModuleImpl);
                if (cl != null) {
                    return cl;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to get field {}", (Object)Felix_ModuleImpl_m_ClassLoader_Field, (Object)e);
                return null;
            }
            {
                catch (Exception e) {
                    LOG.warn("Unable to load old felix container", (Throwable)e);
                    return null;
                }
            }
            try {
                bundle.loadClass("java.lang.Object");
                cl = (ClassLoader)Felix_ModuleImpl_m_ClassLoader_Field.get(currentModuleImpl);
                return cl;
            }
            catch (Exception e) {
                LOG.warn("Unable to get field {}", (Object)Felix_ModuleImpl_m_ClassLoader_Field, (Object)e);
                return null;
            }
        }
        LOG.warn("No classloader for felix platform for bundle " + bundle.getSymbolicName());
        return null;
    }

    private static ClassLoader internalGetConciergeBundleClassLoader(Bundle bundle) {
        if (osgiContainer == OSGiContainerType.Concierge) {
            try {
                if (Concierge_BundleWiring_Class == null) {
                    Concierge_BundleWiring_Class = bundle.getClass().getClassLoader().loadClass("org.osgi.framework.wiring.BundleWiring");
                    Concierge_BundleImpl_Adapt_Method = Concierge_BundleImpl_Class.getMethod("adapt", Class.class);
                    Concierge_BundleImpl_Adapt_Method.setAccessible(true);
                    Concierge_BundleWiring_getClassLoader_Method = Concierge_BundleWiring_Class.getMethod("getClassLoader", new Class[0]);
                    Concierge_BundleWiring_getClassLoader_Method.setAccessible(true);
                }
                Object wiring = Concierge_BundleImpl_Adapt_Method.invoke((Object)bundle, Concierge_BundleWiring_Class);
                ClassLoader cl = (ClassLoader)Concierge_BundleWiring_getClassLoader_Method.invoke(wiring, new Object[0]);
                return cl;
            }
            catch (Exception e) {
                LOG.warn("Unable to load Concierge platform", (Throwable)e);
                return null;
            }
        }
        LOG.warn("No classloader for Concierge platform for bundle " + bundle.getSymbolicName());
        return null;
    }

    private static enum OSGiContainerType {
        EquinoxOld,
        EquinoxLuna,
        FelixOld,
        Felix403,
        Concierge;

    }
}

