/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.annotations;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.framework.Bundle;

public class AnnotationParser
extends org.eclipse.jetty.annotations.AnnotationParser {
    private Set<URI> _alreadyParsed = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<URI, Bundle> _uriToBundle = new ConcurrentHashMap();
    private ConcurrentHashMap<Bundle, Resource> _bundleToResource = new ConcurrentHashMap();
    private ConcurrentHashMap<Resource, Bundle> _resourceToBundle = new ConcurrentHashMap();
    private ConcurrentHashMap<Bundle, URI> _bundleToUri = new ConcurrentHashMap();

    public AnnotationParser(int javaPlatform) {
        super(javaPlatform, 458752);
    }

    protected Resource indexBundle(Bundle bundle) throws Exception {
        File bundleFile = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        Resource resource = Resource.newResource((URI)bundleFile.toURI());
        URI uri = resource.getURI();
        this._uriToBundle.putIfAbsent(uri, bundle);
        this._bundleToUri.putIfAbsent(bundle, uri);
        this._bundleToResource.putIfAbsent(bundle, resource);
        this._resourceToBundle.putIfAbsent(resource, bundle);
        return resource;
    }

    protected URI getURI(Bundle bundle) {
        return this._bundleToUri.get(bundle);
    }

    protected Resource getResource(Bundle bundle) {
        return this._bundleToResource.get(bundle);
    }

    protected Bundle getBundle(Resource resource) {
        return this._resourceToBundle.get(resource);
    }

    public void parse(Set<? extends AnnotationParser.Handler> handlers, URI[] uris) throws Exception {
        for (URI uri : uris) {
            Bundle associatedBundle = this._uriToBundle.get(uri);
            if (associatedBundle == null) {
                if (!this._alreadyParsed.add(uri)) continue;
                super.parse(handlers, new URI[]{uri});
                continue;
            }
            this.parse(handlers, associatedBundle);
        }
    }

    protected void parse(Set<? extends AnnotationParser.Handler> handlers, Bundle bundle) throws Exception {
        Enumeration classes;
        URI uri = this._bundleToUri.get(bundle);
        if (!this._alreadyParsed.add(uri)) {
            return;
        }
        String bundleClasspath = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bundleClasspath == null) {
            bundleClasspath = ".";
        }
        TreeSet<String> paths = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int paths2;
                int paths1 = new StringTokenizer(o1, "/", false).countTokens();
                if (paths1 == (paths2 = new StringTokenizer(o2, "/", false).countTokens())) {
                    return o1.compareTo(o2);
                }
                return paths2 - paths1;
            }
        });
        boolean hasDotPath = false;
        StringTokenizer tokenizer = new StringTokenizer(bundleClasspath, ",;", false);
        while (tokenizer.hasMoreTokens()) {
            Object token = tokenizer.nextToken().trim();
            if (!((String)token).startsWith("/")) {
                token = "/" + (String)token;
            }
            if (((String)token).equals("/.")) {
                hasDotPath = true;
                continue;
            }
            if (!((String)token).endsWith(".jar") && !((String)token).endsWith("/")) {
                paths.add((String)token + "/");
                continue;
            }
            paths.add((String)token);
        }
        if (bundle.getEntry("/.classpath") != null) {
            if (bundle.getEntry("/bin/") != null) {
                paths.add("/bin/");
            } else if (bundle.getEntry("/target/classes/") != null) {
                paths.add("/target/classes/");
            }
        }
        if ((classes = bundle.findEntries("/", "*.class", true)) == null) {
            return;
        }
        while (classes.hasMoreElements()) {
            URL classUrl = (URL)classes.nextElement();
            String path = classUrl.getPath();
            String name = null;
            for (String prefixPath : paths) {
                if (!path.startsWith(prefixPath)) continue;
                name = path.substring(prefixPath.length());
                break;
            }
            if (name == null && hasDotPath) {
                name = path.substring(1);
            }
            if (name == null) continue;
            String shortName = StringUtil.replace((String)name, (char)'/', (char)'.').substring(0, name.length() - 6);
            this.addParsedClass(shortName, this.getResource(bundle));
            InputStream classInputStream = classUrl.openStream();
            try {
                this.scanClass(handlers, this.getResource(bundle), classInputStream);
            }
            finally {
                if (classInputStream == null) continue;
                classInputStream.close();
            }
        }
    }
}

